% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotResiduals}
\alias{plotResiduals}
\title{Plot residuals for a fitlist}
\usage{
plotResiduals(parframe, x, data, split = "condition", errmodel = NULL,
  ...)
}
\arguments{
\item{parframe}{Object of class \code{parframe}, e.g. returned by \link{mstrust}}

\item{x}{Prediction function returning named list of data.frames with names as \code{data}.}

\item{data}{Named list of data.frames, i.e. with columns \code{name}, \code{time}, 
\code{value} and \code{sigma}.}

\item{split}{List of characters specifying how to summarise the residuals by \code{sqrt(res_i^2)}, 
\code{split[1]} used for x-axis, \code{split[2]} for grouping (color), and any additional for \code{facet_wrap()}}

\item{errmodel}{object of type prdfn, the error model function.}

\item{...}{Additional arguments for x}
}
\value{
A plot object of class \code{ggplot} with data.frame as attribute \code{attr(P,"out")}.
}
\description{
Plot residuals for a fitlist
}
\examples{
\dontrun{
 # time axis:
 plotResiduals(myfitlist, g*x*p, data, 
    c("time","index","condition","name"), 
    conditions = myconditions[1:4])
 # condition axis (residuals summed over time for each observable and condition):
 plotResiduals(myfitlist, g*x*p, data,  c("condition","name","index"))
}
}
