% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_vms.R
\name{preprocessing_vms}
\alias{preprocessing_vms}
\title{Preprocessing Vessel Monitoring System data}
\usage{
preprocessing_vms(files.path, destination.folder)
}
\arguments{
\item{files.path}{it can be a path to the file downloaded or the data object itself.
If function is used with a path it adds a \code{file} column to the returning data.frame object that
stores the name of the file as a reference.}

\item{destination.folder}{it must record the path to a folder were all the preprocessed files
will be stored.}
}
\value{
A \code{.fst} file saved within a directory chosen by the user, that is created automatically if does not exist, and that stores
each of the files that are used as input to the function.
}
\description{
This functions bundles all the cleaning functions and allows them to be
easily used in parallel processing to speed up the cleaning of all the Vessel Monitoring System, VMS, data \code{.csv} files.
While it runs, it creates a folder called \code{preprocessed} that will store VMS data that
underwent the preprocessing. If multiple files are used as input (see examples below) it will create
multiple files. All the outputs are in \code{.fst} format, which allows fast upload of large files.
See \code{fst} package documentation for further information https://www.fstpackage.org/.
}
\examples{

# An example with the `sample.dataset`
\donttest{
preprocessing_vms(sample_dataset, destination.folder = tempdir())
}

}
