% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_data.R
\name{[.ts_data}
\alias{[.ts_data}
\title{Subset Extraction for Time Series Data}
\usage{
\method{[}{ts_data}(x, i, j, ...)
}
\arguments{
\item{x}{\code{ts_data} object}

\item{i}{row i}

\item{j}{column j}

\item{...}{optional arguments}
}
\value{
returns a new ts_data object
}
\description{
Extracts a subset of a time series object based on specified rows and columns.
The function allows for flexible indexing and subsetting of time series data.
}
\examples{
data(sin_data)
data10 <- ts_data(sin_data$y, 10)
ts_head(data10)
#single line
data10[12,]

#range of lines
data10[12:13,]

#single column
data10[,1]

#range of columns
data10[,1:2]

#range of rows and columns
data10[12:13,1:2]

#single line and a range of columns
#'data10[12,1:2]

#range of lines and a single column
data10[12:13,1]

#single observation
data10[12,1]
}
