% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot_lollipop}
\alias{plot_lollipop}
\title{Plot lollipop}
\usage{
plot_lollipop(
  data,
  label_x = "",
  label_y = "",
  colors = NULL,
  color_text = "black",
  size_text = 3,
  size_ball = 8,
  alpha_ball = 0.2,
  min_value = 0,
  max_value_gap = 1
)
}
\arguments{
\item{data}{data.frame contain x, value, and variable}

\item{label_x}{x-axis label}

\item{label_y}{y-axis label}

\item{colors}{color vector}

\item{color_text}{color of text inside ball}

\item{size_text}{size of text inside ball}

\item{size_ball}{size of ball}

\item{alpha_ball}{transparency of ball}

\item{min_value}{minimum value}

\item{max_value_gap}{maximum value gap}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
This function creates a lollipop chart using ggplot2.
}
\examples{
#summarizing iris dataset
data <- iris |> dplyr::group_by(Species) |>
dplyr::summarize(Sepal.Length=mean(Sepal.Length))
head(data)

#ploting data
grf <- plot_lollipop(data, colors="blue", max_value_gap=0.2)
plot(grf)
}
