% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot_ts_pred}
\alias{plot_ts_pred}
\title{Plot a time series chart with predictions}
\usage{
plot_ts_pred(
  x = NULL,
  y,
  yadj,
  ypred = NULL,
  label_x = "",
  label_y = "",
  color = "black",
  color_adjust = "blue",
  color_prediction = "green"
)
}
\arguments{
\item{x}{time index}

\item{y}{time series}

\item{yadj}{adjustment of time series}

\item{ypred}{prediction of the time series}

\item{label_x}{x-axis title}

\item{label_y}{y-axis title}

\item{color}{color for the time series}

\item{color_adjust}{color for the adjusted values}

\item{color_prediction}{color for the predictions}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
This function plots a time series chart with three lines: the original series, the adjusted series, and the predicted series using ggplot2.
}
\examples{
x <- base::seq(0, 10, 0.25)
yvalues <- sin(x) + rnorm(41,0,0.1)
adjust <- sin(x[1:35])
prediction <- sin(x[36:41])
grf <- plot_ts_pred(y=yvalues, yadj=adjust, ypre=prediction)
plot(grf)
}
