% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basinandbuffers.R
\name{basinandbuffers}
\alias{basinandbuffers}
\title{Buffers the reservoir and the river, and clips to basin areas}
\usage{
basinandbuffers(
  reservoir,
  upstream,
  downstream,
  basins,
  streambuffersize,
  reservoirbuffersize
)
}
\arguments{
\item{reservoir}{An sf polygon, with an unstandardised raw reservoir}

\item{upstream}{An sf line, following the river upstream of the reservoir}

\item{downstream}{An sf line, following the river downstream of the reservoir}

\item{basins}{An sf multipolygon, with the basins in the area around the dam}

\item{streambuffersize}{A number indicating the distance around the upstream and downstream river to consider as impacted. Defaults to 2000 (2km).}

\item{reservoirbuffersize}{A number indicating the distance around the reserviur to consider as impacted. Defaults to 5000 (5km)}
}
\value{
A two element list. Element 1 is an sf multipolygon with the reservoir buffer, upstream and downstream areas. Element 2 is the same, but clipped to river basin polygons.
}
\description{
Buffers the reservoir and the river, and clips to basin areas
}
