% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsa_oneway.R
\name{create_dsa_oneway}
\alias{create_dsa_oneway}
\title{Create one-way deterministic sensitivity analysis object}
\usage{
create_dsa_oneway(
  parameters,
  effectiveness = NULL,
  strategies,
  cost = NULL,
  currency = "$",
  other_outcome = NULL
)
}
\arguments{
\item{parameters}{parameter values associated with costs, effectiveness, or other outcomes.
The table must have two columns, with each parameter name in the first column
and the associated parameter value in the second column:

\tabular{ll}{
parameter      \tab value \cr
param1 name     \tab param1 val1 \cr
...            \tab ... \cr
param2 name     \tab  param2 val1 \cr
...            \tab ... \cr
}}

\item{effectiveness}{data frames containing data for costs,
effectiveness or another outcome (user-defined), respectively.
Each simulation should be a row of the data frame, and each strategy should be a column.
Naming the columns of the data frames is not necessary, as they will be renamed with
the \code{strategies} vector.}

\item{strategies}{vector with the names of the strategies. Due to requirements in
certain uses of this vector, this function uses \code{\link{make.names}} to modify
strategy names as necessary. It is strongly suggested that you follow the rules
in the \code{\link{make.names}} help page, to avoid unexpected errors.}

\item{cost}{data frames containing data for costs,
effectiveness or another outcome (user-defined), respectively.
Each simulation should be a row of the data frame, and each strategy should be a column.
Naming the columns of the data frames is not necessary, as they will be renamed with
the \code{strategies} vector.}

\item{currency}{symbol for the currency being used (ex. "$", "£")}

\item{other_outcome}{data frames containing data for costs,
effectiveness or another outcome (user-defined), respectively.
Each simulation should be a row of the data frame, and each strategy should be a column.
Naming the columns of the data frames is not necessary, as they will be renamed with
the \code{strategies} vector.}
}
\value{
a class \code{dsa_oneway} object that can be passed to the \code{\link{owsa}} function
to visualize the one-way sensitivity analyses contained in the object.
}
\description{
The object returned by this function can be passed to
\code{\link{owsa}} to do a one-way sensitivity analysis on each
parameter of interest.
}
