% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_dsa.R
\name{run_twsa_det}
\alias{run_twsa_det}
\title{Run deterministic two-way sensitivity analysis (TWSA)}
\usage{
run_twsa_det(
  params_range,
  params_basecase,
  nsamp = 40,
  FUN,
  outcomes = NULL,
  strategies = NULL,
  progress = TRUE,
  ...
)
}
\arguments{
\item{params_range}{data.frame with 2 rows and 3 columns in the following order: "pars",
"min", and "max". The number of samples from this range is
determined by \code{nsamp}. "pars" are the 2 parameters of interest, which must be a subset of
the parameters from \code{params_basecase}.}

\item{params_basecase}{a named list of basecase values for input parameters needed by \code{FUN},
the user-defined function.}

\item{nsamp}{number of parameter values. If \code{NULL}, 40 parameter values are
used}

\item{FUN}{Function that takes the basecase in \code{params_all} and \code{...} to
produce the \code{outcome} of interest. The \code{FUN} must return a dataframe
where the first column are the strategy names and the rest of the columns must be outcomes.}

\item{outcomes}{String vector with the outcomes of interest from \code{FUN}
produced by \code{nsamp}}

\item{strategies}{vector of strategy names. The default (NULL) will use
strategy names in FUN}

\item{progress}{\code{TRUE} or \code{FALSE} for whether or not function progress
should be displayed in console.}

\item{...}{Additional arguments to user-defined \code{FUN}}
}
\value{
A list containing dataframes with the results of the sensitivity analyses.
The list will contain a dataframe for each outcome specified.
}
\description{
This function runs a deterministic two-way sensitivity analysis (TWSA) on a
given function that produces outcomes.
}
\section{Details}{

\itemize{
\item \code{params_range}
\itemize{
\item "pars" are the names of the two input parameters of interest. The two variables in "pars" column
 must be a subset of variables in \code{params_basecase}
\item "min" and "max" are the mininum and maximum values of the parameters of interest.}
}
}

