% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dann.R
\name{dann_source}
\alias{dann_source}
\title{Discriminant Adaptive Nearest Neighbor Classification}
\usage{
dann_source(xTrain, yTrain, xTest, k = 5,
  neighborhood_size = max(floor(nrow(xTrain)/5), 50), epsilon = 1,
  probability = FALSE)
}
\arguments{
\item{xTrain}{Train features. Something easily converted to a numeric matrix.}

\item{yTrain}{Train classes. Something easily converted to a numeric vector.}

\item{xTest}{Test features. Something easily converted to a numeric matrix.}

\item{k}{The number of data points used for final classification.}

\item{neighborhood_size}{The number of data points used to calculate between and within class covariance.}

\item{epsilon}{Diagonal elements of a diagonal matrix. 1 is the identity matrix.}

\item{probability}{Should probabilities instead of classes be returned?}
}
\value{
A numeric vector containing predicted class or a numeric matrix containing class probabilities.
}
\description{
Discriminant Adaptive Nearest Neighbor Classification
}
\keyword{internal}
