% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/darch.Learn.R
\docType{methods}
\name{fineTuneDArch,DArch-method}
\alias{fineTuneDArch,DArch-method}
\title{Fine tuning function for the deep architecture}
\usage{
\S4method{fineTuneDArch}{DArch}(darch, dataSet, dataSetValid = NULL,
  numEpochs = 1, isClass = TRUE, stopErr = -Inf, stopClassErr = 101,
  stopValidErr = -Inf, stopValidClassErr = 101,
  shuffleTrainData = getParameter(".shuffleTrainData", T),
  debugMode = getParameter(".debug", F), ...)
}
\arguments{
\item{darch}{A instance of the class \code{\linkS4class{DArch}}.}

\item{dataSet}{\code{\linkS4class{DataSet}} containing training and 
optionally validation and test data.}

\item{dataSetValid}{\code{\linkS4class{DataSet}} to be used for validation.}

\item{numEpochs}{The number of training iterations}

\item{isClass}{Indicates whether the training is for a classification net. 
When \code{TRUE} then statistics for classification will be determind. 
Default is \code{TRUE}}

\item{stopErr}{Stop criteria for the error on the train data. Default is 
\code{-Inf}}

\item{stopClassErr}{Stop criteria for the classification error on the train 
data. Default is \code{101}}

\item{stopValidErr}{Stop criteria for the error on the validation data. 
Default is \code{-Inf}.}

\item{stopValidClassErr}{Stop criteria for the classification error on the 
validation data. Default is \code{101}.}

\item{shuffleTrainData}{Whether to shuffle train data before each epoch.}

\item{debugMode}{Whether to enable debug mode, internal parameter.}

\item{...}{Additional parameters for the training function}
}
\description{
Fine tuning function for the deep architecture
}
\seealso{
\link{fineTuneDArch}
}
\keyword{internal}

