% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/darchUnitFunctions.R
\name{sigmoidUnit}
\alias{sigmoidUnit}
\title{Sigmoid unit function with unit derivatives.}
\usage{
sigmoidUnit(input, ...)
}
\arguments{
\item{input}{Input for the activation function.}

\item{...}{Additional parameters, not used.}
}
\value{
A list with the activation in the first entry and the derivative of
  the transfer function in the second entry.
}
\description{
The function calculates the activation and returns a list which the first
entry is the result through the sigmoid transfer function and the second
entry is the derivative of the transfer function.
}
\examples{
\dontrun{
data(iris)
model <- darch(Species ~ ., iris, darch.unitFunction = "sigmoidUnit")
}
}
\seealso{
Other darch unit functions: \code{\link{exponentialLinearUnit}},
  \code{\link{linearUnit}}, \code{\link{maxoutUnit}},
  \code{\link{rectifiedLinearUnit}},
  \code{\link{softmaxUnit}}, \code{\link{softplusUnit}},
  \code{\link{tanhUnit}}
}

