% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/darchUnitFunctions.R
\name{softmaxUnit}
\alias{softmaxUnit}
\title{Softmax unit function with unit derivatives.}
\usage{
softmaxUnit(input, ...)
}
\arguments{
\item{input}{Input for the activation function.}

\item{...}{Additional parameters, not used.}
}
\value{
A list with the softmax activation in the first entry and the
derivative of the transfer function in the second entry.
}
\description{
The function calculates the activation of the units and returns a list, in
which the first entry is the result through the softmax transfer function
and the second entry is the derivative of the transfer function.
}
\examples{
\dontrun{
data(iris)
model <- darch(Species ~ ., iris,
 darch.unitFunction = c("sigmoidUnit", "softmaxUnit"))
}
}
\references{
http://www.faqs.org/faqs/ai-faq/neural-nets/part2/section-12.html
}
\seealso{
Other darch unit functions: \code{\link{exponentialLinearUnit}},
  \code{\link{linearUnit}}, \code{\link{maxoutUnit}},
  \code{\link{rectifiedLinearUnit}},
  \code{\link{sigmoidUnit}}, \code{\link{softplusUnit}},
  \code{\link{tanhUnit}}
}

