% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2geno.r
\name{gl2geno}
\alias{gl2geno}
\title{Converts a genlight object to geno format from package LEA}
\usage{
gl2geno(x, outfile = "gl_geno", outpath = NULL, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP or presence/absence
(SilicoDArT) data [required].}

\item{outfile}{File name of the output file [default 'gl_geno'].}

\item{outpath}{Path where to save the output file [default global working 
directory or if not specified, tempdir()].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
returns no value (i.e. NULL)
}
\description{
The function converts a genlight object (SNP or presence/absence
 i.e. SilicoDArT data) into a file in the 'geno' and the 'lfmm' formats from 
 (package LEA).
}
\examples{
# SNP data
gl2geno(testset.gl, outpath=tempdir())
# Tag P/A data
gl2geno(testset.gs, outpath=tempdir())

}
\seealso{
Other linker: 
\code{\link{gl2bayesAss}()},
\code{\link{gl2bayescan}()},
\code{\link{gl2bpp}()},
\code{\link{gl2demerelate}()},
\code{\link{gl2eigenstrat}()},
\code{\link{gl2fasta}()},
\code{\link{gl2faststructure}()},
\code{\link{gl2gds}()},
\code{\link{gl2genalex}()},
\code{\link{gl2genepop}()},
\code{\link{gl2gi}()},
\code{\link{gl2hiphop}()},
\code{\link{gl2phylip}()},
\code{\link{gl2plink}()},
\code{\link{gl2related}()},
\code{\link{gl2sa}()},
\code{\link{gl2structure}()},
\code{\link{gl2treemix}()},
\code{\link{gl2vcf}()}
}
\author{
Custodian: Luis Mijangos (Post to
\url{https://groups.google.com/d/forum/dartr})
}
\concept{linker}
