% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.subsample.loci.r
\name{gl.subsample.loci}
\alias{gl.subsample.loci}
\title{Subsample n loci from a genlight object and return as a genlight object}
\usage{
gl.subsample.loci(gl, n, method = "random")
}
\arguments{
\item{gl}{-- name of the genlight object containing the SNP genotypes by specimen and population [required]}

\item{n}{-- number of loci to include in the subsample [required]}

\item{method}{-- "random", in which case the loci are sampled at random; or avgPIC, in which case the top n loci
ranked on information content (AvgPIC) are chosen [default "random"]}
}
\value{
A genlight object with n loci
}
\description{
This is a support script, to subsample a genlight \{adegenet\} object based on loci. Two methods are used
to subsample, random and based on information content (avgPIC)
}
\examples{
\dontrun{
result <- gl.subsample.loci(gl, n=200, method="avgPIC")
}
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}

