% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.collapse.r
\name{gl.collapse}
\alias{gl.collapse}
\title{Collapse a distance matrix by amalgamating populations}
\usage{
gl.collapse(fd, gl, recode.table = "tmp.csv", tpop = 0, v = 1)
}
\arguments{
\item{fd}{-- name of the distance matrix produced by gl.fixed.diff() [required]}

\item{gl}{-- name of the genlight object from which the distance matrix was calculated [required]}

\item{recode.table}{-- name of the new recode.table to receive the new population reassignments 
arising from the amalgamation of populations [default tmp.csv]}

\item{tpop}{-- max number of fixed differences used amalgamating populations [default 0]}

\item{v}{-- verbosity = 0, silent; 1, brief; 2, verbose [default 1]}
}
\value{
The new genlight object with recoded populations
}
\description{
This script takes a distance matrix (d, lower matrix) and generates a population recode
table to amalgamate populations with distance less than or equal to a specified threshold
The distance matrix is generated by gl.fixed.diff()
}
\examples{
\dontrun{
#only used the first 20 individuals due to runtime reasons 
fd <- gl.fixed.diff(testset.gl[1:20,], tloc=0.05)
gl <- gl.collapse(fd, testset.gl, recode.table="testset_recode.csv",tpop=1)
}

}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
