% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.grm.network.r
\name{gl.grm.network}
\alias{gl.grm.network}
\title{Represents a genomic relatedness matrix as a network}
\usage{
gl.grm.network(G, x, method = "fr", node.size = 3,
  node.label = FALSE, node.label.size = 0.7,
  node.label.color = "black", alpha = 0.004,
  title = "Network based on G-matrix of genetic relatedness", v = 3)
}
\arguments{
\item{G}{-- a G relatedness matrix generated by gl.grm [required]}

\item{x}{-- genlight object from which the G matrix was generated [required]}

\item{method}{-- one of fr, kk or drl [Default:fr]}

\item{node.size}{-- size of the symbols for the network nodes [default: 3]}

\item{node.label}{-- TRUE to display node labels [default: FALSE]}

\item{node.label.size}{-- Size of the node labels [default: 0.7]}

\item{node.label.color}{-- color of the text of the node labels [default: "black"]}

\item{alpha}{-- upper threshold to determine which links between nodes to display [default: 0.995]}

\item{title}{-- title for the plot [default: "Network based on G-matrix of genetic relatedness"]}

\item{v}{-- verbosity. If zero silent, max 3.}
}
\description{
This script takes a G matrix generated by gl.grm() and represents the relationship among the specimens as a network diagram. In order to use this script,
a decision is required on a threshold for relatedness to be represented as link in the network, and on the layout used to create the diagram.
}
\details{
The threshold for relatedness to be represented as a link in the network is specified as a quantile. Those relatedness measures above the quantile are
plotted as links, those below the quantile are not. Often you are looking for relatedness outliers in comparison with the overall relatedness among individuals,
so a very conservative quantile is used (e.g. 0.004), but ultimately, this decsion is made as a matter of trial and error. One way to approach this trial and error
is to try to achieve a sparse set of links between unrelated 'background' individuals so that the stronger links are preferentially shown.

There are several layouts from which to choose. The most popular are given as options in this script.

fr -- Fruchterman, T.M.J. and Reingold, E.M. (1991). Graph Drawing by Force-directed Placement. Software -- Practice and Experience 21:1129-1164.
kk -- Kamada, T. and Kawai, S.: An Algorithm for Drawing General Undirected Graphs. Information Processing Letters 31:7-15, 1989. 
drl -- Martin, S., Brown, W.M., Klavans, R., Boyack, K.W., DrL: Distributed Recursive (Graph) Layout. SAND Reports 2936:1-10, 2008.

colors of node symbols are those of the rainbow.
}
\examples{
#gl.grm.network(G,x)  
}
\author{
Arthur Georges (bugs? Post to \url{https://groups.google.com/d/forum/dartr})
}
