% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.costdistances.r
\name{gl.costdistances}
\alias{gl.costdistances}
\title{Calculates cost distances for a given landscape (resistance matrix)}
\usage{
gl.costdistances(landscape, locs, method, NN)
}
\arguments{
\item{landscape}{a raster object coding the resistance of the landscape}

\item{locs}{coordinates of the subpopulations. If a genlight object is provided coordinates are taken from @other$latlong and centers for population (pop(gl)) are calculated. In case you want to calculate costdistances between individuals redefine pop(gl) via: \code{pop(gl)<- indNames(gl)}.}

\item{method}{defines the type of cost distance, types are "least-cost", "rSPDistance" or "commute (Circuitscape type)"}

\item{NN}{number of next neighbours recommendation is 8}
}
\value{
a costdistance matrix between all pairs of locs
}
\description{
calculates a cost distance matrix, to be used with run.popgensim
}
\examples{
\dontrun{
data(possums.gl)
library(raster)  #needed for that example
landscape.sim <- readRDS(system.file("extdata","landscape.sim.rdata", package="dartR"))
#calculate mean centers of individuals per population
xy <- apply(possums.gl@other$xy, 2, function(x) tapply(x, pop(possums.gl), mean))
cd <- gl.costdistances(landscape.sim, xy, method="leastcost", NN=8)
round(cd,3)
}
}
