% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.parent.offspring.r
\name{gl.report.parent.offspring}
\alias{gl.report.parent.offspring}
\title{Identify putative parent offspring within a population}
\usage{
gl.report.parent.offspring(
  x,
  min.rdepth = 12,
  min.reproducibility = 1,
  range = 1.5,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP genotypes [required]}

\item{min.rdepth}{Minimum read depth to include in analysis [default = 12]}

\item{min.reproducibility}{Minimum reproducibility to include in analysis [default = 1]}

\item{range}{-- specifies the range to extend beyond the interquartile range for delimiting outliers [default = 1.5 interquartile ranges]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\value{
A set of individuals in parent-offspring relationship
}
\description{
This script examines the frequency of pedigree inconsistent loci, that is,
those loci that are homozygotes in the parent for the reference allele, and
homozygous in the offspring for the alternate allele. This condition is not
consistent with any pedigree, regardless of the (unkonwn) genotype of the other
parent. The pedigree inconsistent loci are counted as an indication of whether
or not it is reasonable to propose the two individuals are in a parent-offspring
relationship.
}
\details{
Obviously, if the two individuals are in a parent offspring relationship, the true
number of pedigree inconsistent loci should be zero, but SNP calling is not 
infallible. Some loci will be mis-called. The problem thus becomes one of determining
if the two focal individuals have a count of pedigree inconsistent loci less than
would be expected of typical unrelated individuals. There are some quite sophisticated
software packages available to formally apply likelihoods to the decision, but we
use a simple outlier comparison.

To reduce the frequency of mis-calls, and so emphasise the difference between true
parent-offspring pairs and unrelated pairs, the data can be filtered on read depth.
Typically minimum read depth is set to 5x, but you can examine the distribution
of read depths with gl.report.rdepth() and push this up with an acceptable loss
of loci. 12x might be a good minimum for this particular analysis. It is sensible
also to push the minimum reproducibility up to 1, if that does not result in an
unacceptable loss of loci.

Note that the null expectation is not well defined, and the power reduced, if the
population from which the putative parent-offspring pairs are drawn contains 
many sibs. Note also that if an individual has been genotyped twice in the dataset, 
the replicate pair will be assessed by this script as being in a parent-offspring 
relationship.
}
