% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.jackknife.R
\name{utils.jackknife}
\alias{utils.jackknife}
\title{Conducts jackknife resampling using a genlight object}
\usage{
utils.jackknife(
  x,
  FUN,
  unit = "loc",
  recalc = FALSE,
  mono.rm = FALSE,
  n.cores = "auto",
  verbose = NULL,
  ...
)
}
\arguments{
\item{x}{Name of the genlight object containing SNP genotypes [required].}

\item{FUN}{the name of the function to be used to calculate the statistic}

\item{unit}{The unit to use for resampling. One of c("loc", "ind", "pop"): 
loci, individuals or populations}

\item{recalc}{Recalculate the locus metadata statistics [default FALSE].}

\item{mono.rm}{Remove monomorphic loci [default FALSE].}

\item{n.cores}{The number of cores to use. If "auto" [default], it will 
use all but one available cores.}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}

\item{...}{any additional arguments to be passed to FUN}
}
\value{
A list of length n where each element is the output of FUN
}
\description{
Jackknife resampling is a statistical procedure where for a dataset of sample 
size n, subsamples of size n-1 are used to compute a statistic. The collection 
of the values obtained can be used to evaluate the variability around the point 
estimate. This function can take the loci, the individuals or the populations 
as units over which to conduct resampling.

bold{Note} that when n is very small, jackknife resampling is not recommended.

Parallel computation is implemented. The argument code{n.cores} indicates the 
number of core to use. If "auto" [default], it will use all but one available 
cores. If the number of units is small (e.g. a few populations), there is not 
real advantage in using parallel computation. On the other hand, if the number 
of units is large (e.g. thousands of loci), even with parallel computation, 
this function can be very slow.
}
\examples{
platMod.gl <- gl.filter.allna(platypus.gl) 
chk.pop <- utils.jackknife(x=platMod.gl, FUN="gl.alf", unit="pop", 
recalc = FALSE, mono.rm = FALSE, n.cores = 1, verbose=0)
}
\author{
Custodian: Carlo Pacioni -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
