% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_conversion_dataframe.R
\name{as.Node.data.frame}
\alias{FromDataFrameNetwork}
\alias{FromDataFrameTable}
\alias{as.Node.data.frame}
\title{Convert a \code{data.frame} to a \code{data.tree} structure}
\usage{
\method{as.Node}{data.frame}(x, ..., mode = c("table", "network"),
  pathName = "pathString", pathDelimiter = "/", colLevels = NULL,
  na.rm = TRUE)

FromDataFrameTable(table, pathName = "pathString", pathDelimiter = "/",
  colLevels = NULL, na.rm = TRUE, check = c("check", "no-warn",
  "no-check"))

FromDataFrameNetwork(network, check = c("check", "no-warn", "no-check"))
}
\arguments{
\item{x}{The data.frame in the required format.}

\item{...}{Any other argument implementations of this might need}

\item{mode}{Either "table" (if x is a data.frame in tree or table format) or "network"}

\item{pathName}{The name of the column in x containing the path of the row}

\item{pathDelimiter}{The delimiter used}

\item{colLevels}{Nested list of column names, determining on what node levels the attributes are written to.}

\item{na.rm}{If \code{TRUE}, then NA's are treated as NULL and values will not be set on nodes}

\item{table}{a \code{data.frame} in table or tree format, i.e. having a row for each leaf (and optionally
for additional nodes). There should be a column called \code{pathName}, separated by \code{pathDelimiter},
describing the path of each row.}

\item{check}{Either
\itemize{
 \item{\code{"check"}: if the name conformance should be checked and warnings should be printed in case of non-conformance (the default)}
 \item{\code{"no-warn"}: if the name conformance should be checked, but no warnings should be printed in case of non-conformance (if you expect non-conformance)}
 \item{\code{"no-check" or FALSE}: if the name conformance should not be checked; use this if performance is critical. However, in case of non-conformance, expect cryptic follow-up errors}
}}

\item{network}{A \code{data.frame} in network format, i.e.
it must adhere to the following requirements:
\itemize{
 \item{It must contain as many rows as there are nodes (excluding the root, there is no row for the root)}
 \item{Its first and second columns contain the network relationships. This can be either climbing (from parent to children) or descending (from child to parent)}
 \item{Its subsequent columns contain the attributes to be set as fields on the nodes}
 \item{It must contain a single root}
 \item{There are no cycles in the network}
}}
}
\value{
The root \code{Node} of the \code{data.tree} structure
}
\description{
Convert a \code{data.frame} to a \code{data.tree} structure
}
\examples{
data(acme)

#Tree
x <- ToDataFrameTree(acme, "pathString", "p", "cost")
x
xN <- as.Node(x)
print(xN, "p", "cost")

#Table
x <- ToDataFrameTable(acme, "pathString", "p", "cost")
x
xN <- FromDataFrameTable(x)
print(xN, "p", "cost")

#More complex Table structure, using colLevels
acme$Set(floor = c(1, 2, 3),  filterFun = function(x) x$level == 2)
x <- ToDataFrameTable(acme, "pathString", "floor", "p", "cost")
x
xN <- FromDataFrameTable(x, colLevels = list(NULL, "floor", c("p", "cost")), na.rm = TRUE)
print(xN, "floor", "p", "cost")

#Network
x <- ToDataFrameNetwork(acme, "p", "cost", direction = "climb")
x
xN <- FromDataFrameNetwork(x)
print(xN, "p", "cost")

}
\seealso{
\code{\link{as.data.frame.Node}}

Other as.Node: \code{\link{as.Node.dendrogram}},
  \code{\link{as.Node.list}}, \code{\link{as.Node.phylo}},
  \code{\link{as.Node}}
}

