% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datesManipulations.R
\name{findAndTransformDates}
\alias{findAndTransformDates}
\title{Identify date columns}
\usage{
findAndTransformDates(dataSet, formats = NULL, n_test = 30,
  verbose = TRUE)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{formats}{List of additional Date formats to check (see \code{\link{strptime}})}

\item{n_test}{Number of non-null rows on which to test (numeric, default to 30)}

\item{verbose}{Should the algorithm talk? (Logical, default to TRUE)}
}
\value{
dataSet set (as a data.table) with identified dates transformed by \strong{reference}.
}
\description{
Find and transform dates that are hidden in a character column. \cr
It use a bunch of default formats, and you can also add your own formats.
}
\details{
This function is looking for perfect transformation. 
If there are some mistakes in dataSet, consider setting them to NA before. \cr
In the unlikely case where you have numeric higher than \code{as.numeric(as.POSIXct("1990-01-01"))}
they will be considered as timestamps and you might have some issues. On the other side, 
if you have timestamps before 1990-01-01, they won't be found, but you can use 
\code{\link{setColAsDate}} to force transformation.
}
\examples{
# Load exemple set
data(messy_adult)
head(messy_adult)
# using the findAndTransformDates
findAndTransformDates(messy_adult, n_test = 5)
head(messy_adult)
}
