% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getNWISData}
\alias{getNWISData}
\title{General Data Import from NWIS}
\usage{
getNWISData(service = "dv", ...)
}
\arguments{
\item{service}{string. Possible values are "iv" (for instantaneous), "dv" (for daily values), "gwlevels"
(for groundwater levels), and "qwdata" (for water quality)}

\item{\dots}{see \url{http://waterservices.usgs.gov/rest/Site-Service.html#Service} for a complete list of options}
}
\value{
retval dataframe
}
\description{
Returns data from the NWIS web service.
Arguments to the function should be based on \url{http://waterservices.usgs.gov} service calls.
}
\examples{
dataTemp <- getNWISData(stateCd="OH",parameterCd="00010")
dataTempUnit <- getNWISData(sites="03086500", service="iv", parameterCd="00010")
}
\keyword{NWIS}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}

