% Generated by roxygen2 (4.0.2): do not edit by hand
\name{importRDB1}
\alias{importRDB1}
\title{Function to return data from the NWIS RDB 1.0 format}
\usage{
importRDB1(obs_url, asDateTime = FALSE, qw = FALSE, convertType = TRUE,
  tz = "")
}
\arguments{
\item{obs_url}{string containing the url for the retrieval}

\item{asDateTime}{logical, if TRUE returns date and time as POSIXct, if FALSE, Date}

\item{qw}{logical, if TRUE parses as water quality data (where dates/times are in start and end times)}

\item{convertType}{logical, defaults to TRUE. If TRUE, the function will convert the data to dates, datetimes,
numerics based on a standard algorithm. If false, everything is returned as a string.}

\item{tz}{string to set timezone attribute of datetime. Default is an empty quote, which converts the
datetimes to UTC (properly accounting for daylight savings times based on the data's provided tz_cd column).
Possible values to provide are "America/New_York","America/Chicago", "America/Denver","America/Los_Angeles",
"America/Anchorage","America/Honolulu","America/Jamaica","America/Managua","America/Phoenix", and "America/Metlakatla"}
}
\value{
data a data frame containing columns agency, site, dateTime (converted to UTC), values, and remark codes for all requested combinations
}
\description{
This function accepts a url parameter that already contains the desired
NWIS site, parameter code, statistic, startdate and enddate. It is not
recommended to use the RDB format for importing multi-site data.
}
\examples{
siteNumber <- "02177000"
startDate <- "2012-09-01"
endDate <- "2012-10-01"
offering <- "00003"
property <- "00060"
\dontrun{
obs_url <- constructNWISURL(siteNumber,property,
         startDate,endDate,"dv",format="tsv")
data <- importRDB1(obs_url)
urlMultiPcodes <- constructNWISURL("04085427",c("00060","00010"),
         startDate,endDate,"dv",statCd=c("00003","00001"),"tsv")
multiData <- importRDB1(urlMultiPcodes)
unitDataURL <- constructNWISURL(siteNumber,property,
         "2013-11-03","2013-11-03","uv",format="tsv") #includes timezone switch
unitData <- importRDB1(unitDataURL, asDateTime=TRUE)
qwURL <- constructNWISURL(c('04024430','04024000'),
          c('34247','30234','32104','34220'),
         "2010-11-03","","qw",format="rdb")
qwData <- importRDB1(qwURL, qw=TRUE, tz="America/Chicago")
iceSite <- '04024430'
start <- "2013-11-09"
end <- "2013-11-28"
urlIce <- constructNWISURL(iceSite,"00060",start, end,"uv",format="tsv")

# User file:
filePath <- system.file("extdata", package="dataRetrieval")
fileName <- "RDB1Example.txt"
fullPath <- file.path(filePath, fileName)
importUserRDB <- importRDB1(fullPath)
}
}

