% Generated by roxygen2 (4.0.2): do not edit by hand
\name{readNWISmeas}
\alias{readNWISmeas}
\title{Reads surface-water measurement data from NWISweb.}
\usage{
readNWISmeas(siteNumber, startDate = "", endDate = "", tz = "")
}
\arguments{
\item{siteNumber}{string USGS site number.  This is usually an 8 digit number}

\item{startDate}{string starting date for data retrieval in the form YYYY-MM-DD.}

\item{endDate}{string ending date for data retrieval in the form YYYY-MM-DD.}

\item{tz}{string to set timezone attribute of datetime. Default is an empty quote, which converts the
datetimes to UTC (properly accounting for daylight savings times based on the data's provided tz_cd column).
Possible values to provide are "America/New_York","America/Chicago", "America/Denver","America/Los_Angeles",
"America/Anchorage","America/Honolulu","America/Jamaica","America/Managua","America/Phoenix", and "America/Metlakatla"}
}
\description{
Reads surface-water measurement data from NWISweb.
}
\examples{
siteNumber <- '01594440'
data <- readNWISmeas(siteNumber)
}

