% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getNWISqwData}
\alias{getNWISqwData}
\alias{readNWISqw}
\title{Raw Data Import for USGS NWIS QW Data}
\usage{
getNWISqwData(siteNumber, pCodes, startDate = "", endDate = "",
  expanded = FALSE, reshape = TRUE, tz = "")

readNWISqw(siteNumber, pCodes, startDate = "", endDate = "",
  expanded = FALSE, reshape = TRUE, tz = "")
}
\arguments{
\item{siteNumber}{string or vector of of USGS site numbers.  This is usually an 8 digit number}

\item{pCodes}{string or vector of USGS parameter code.  This is usually an 5 digit number.}

\item{startDate}{string starting date for data retrieval in the form YYYY-MM-DD.}

\item{endDate}{string ending date for data retrieval in the form YYYY-MM-DD.}

\item{expanded}{logical defaults to FALSE. If TRUE, retrieves additional information. Expanded data includes
remark_cd (remark code), result_va (result value), val_qual_tx (result value qualifier code), meth_cd (method code),
dqi_cd (data-quality indicator code), rpt_lev_va (reporting level), and rpt_lev_cd (reporting level type).}

\item{reshape}{logical. Will reshape the data if TRUE (default)}

\item{tz}{string to set timezone attribute of datetime. Default is an empty quote, which converts the
datetimes to UTC (properly accounting for daylight savings times based on the data's provided tz_cd column).
Possible values to provide are "America/New_York","America/Chicago", "America/Denver","America/Los_Angeles",
"America/Anchorage","America/Honolulu","America/Jamaica","America/Managua","America/Phoenix", and "America/Metlakatla"}
}
\value{
data dataframe with agency, site, dateTime, value, and code columns
}
\description{
Imports data from NWIS web service. This function gets the data from here: \url{http://nwis.waterdata.usgs.gov/nwis/qwdata}
A list of parameter codes can be found here: \url{http://nwis.waterdata.usgs.gov/nwis/pmcodes/}
A list of statistic codes can be found here: \url{http://nwis.waterdata.usgs.gov/nwis/help/?read_file=stat&format=table}
}
\examples{
siteNumber <- c('04024430','04024000')
startDate <- '2010-01-01'
endDate <- ''
pCodes <- c('34247','30234','32104','34220')
\dontrun{
rawNWISqwData <- readNWISqw(siteNumber,pCodes,startDate,endDate)
rawNWISqwDataExpandReshaped <- readNWISqw(siteNumber,pCodes,
          startDate,endDate,expanded=TRUE)
rawNWISqwDataExpand <- readNWISqw(siteNumber,pCodes,
          startDate,endDate,expanded=TRUE,reshape=FALSE)
          }
}
\seealso{
\code{\link{readWQPdata}}, \code{\link{whatWQPsites}},
\code{\link{readWQPqw}}, \code{\link{constructNWISURL}}
}
\keyword{USGS}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}

