% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whatWQPdata.R
\name{whatWQPsamples}
\alias{whatWQPsamples}
\title{Sampling Activity Data Import from Water Quality Portal}
\usage{
whatWQPsamples(...)
}
\arguments{
\item{\dots}{see \url{https://www.waterqualitydata.us/webservices_documentation} for a complete list of options. A list of arguments can also be supplied.}
}
\value{
A data frame
}
\description{
Returns a list of sites from the Water Quality Portal web service. This function gets the data from: \url{https://www.waterqualitydata.us}.
Arguments to the function should be based on \url{https://www.waterqualitydata.us/webservices_documentation}
}
\examples{
\dontrun{
site1 <- whatWQPsamples(siteid="USGS-01594440")

type <- "Stream"
sites <- whatWQPsamples(countycode="US:55:025",siteType=type)
lakeSites <- whatWQPsamples(siteType = "Lake, Reservoir, Impoundment", statecode = "US:55")
}
}
\keyword{WQP}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}
