% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readNWISpCode.r
\name{readNWISpCode}
\alias{readNWISpCode}
\title{USGS Parameter Data Retrieval}
\usage{
readNWISpCode(parameterCd)
}
\arguments{
\item{parameterCd}{character of USGS parameter codes (or multiple parameter codes).  These are 5 digit number codes,
more information can be found here: \url{https://help.waterdata.usgs.gov/}. To get a 
complete list of all current parameter codes in the USGS, use "all" as the input.}
}
\value{
parameterData data frame with the following information: 
\tabular{lll}{
  Name \tab Type \tab Description\cr
  parameter_cd \tab character \tab 5-digit USGS parameter code \cr
  parameter_group_nm \tab character \tab USGS parameter group name\cr
  parameter_nm \tab character \tab USGS parameter name\cr
  casrn \tab character \tab Chemical Abstracts Service (CAS) Registry Number\cr
  srsname \tab character \tab Substance Registry Services Name\cr
  parameter_units \tab character \tab Parameter units\cr
}
}
\description{
Imports data from NWIS about meaured parameter based on user-supplied parameter code or codes.
This function gets the data from here: \url{https://nwis.waterdata.usgs.gov/nwis/pmcodes}
}
\examples{

paramINFO <- readNWISpCode(c('01075','00060','00931'))
paramINFO <- readNWISpCode(c('01075','00060','00931', NA))
\donttest{
all_codes <- readNWISpCode("all")

}
}
\seealso{
\code{\link{importRDB1}}
}
\keyword{USGS}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}
