% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_waterdata_monitoring_location.R
\name{read_waterdata_monitoring_location}
\alias{read_waterdata_monitoring_location}
\title{Get USGS Site Data}
\usage{
read_waterdata_monitoring_location(
  monitoring_location_id = NA_character_,
  agency_code = NA_character_,
  agency_name = NA_character_,
  monitoring_location_number = NA_character_,
  monitoring_location_name = NA_character_,
  district_code = NA_character_,
  country_code = NA_character_,
  country_name = NA_character_,
  state_code = NA_character_,
  state_name = NA_character_,
  county_code = NA_character_,
  county_name = NA_character_,
  minor_civil_division_code = NA_character_,
  site_type_code = NA_character_,
  site_type = NA_character_,
  hydrologic_unit_code = NA_character_,
  basin_code = NA_character_,
  altitude = NA_character_,
  altitude_accuracy = NA_character_,
  altitude_method_code = NA_character_,
  altitude_method_name = NA_character_,
  vertical_datum = NA_character_,
  vertical_datum_name = NA_character_,
  horizontal_positional_accuracy_code = NA_character_,
  horizontal_positional_accuracy = NA_character_,
  horizontal_position_method_code = NA_character_,
  horizontal_position_method_name = NA_character_,
  original_horizontal_datum = NA_character_,
  original_horizontal_datum_name = NA_character_,
  drainage_area = NA_character_,
  contributing_drainage_area = NA_character_,
  time_zone_abbreviation = NA_character_,
  uses_daylight_savings = NA_character_,
  construction_date = NA_character_,
  aquifer_code = NA_character_,
  national_aquifer_code = NA_character_,
  aquifer_type_code = NA_character_,
  well_constructed_depth = NA_character_,
  hole_constructed_depth = NA_character_,
  depth_source_code = NA_character_,
  properties = NA_character_,
  bbox = NA,
  limit = NA,
  max_results = NA,
  skipGeometry = NA
)
}
\arguments{
\item{monitoring_location_id}{A unique identifier representing a single monitoring location. This corresponds to the \code{id} field in the \code{monitoring-locations} endpoint. Monitoring location IDs are created by combining the agency code of the agency responsible for the monitoring location (e.g. USGS) with the ID number of the monitoring location (e.g. 02238500), separated by a hyphen (e.g. USGS-02238500).}

\item{agency_code}{The agency that is reporting the data. Agency codes are fixed values assigned by the National Water Information System (NWIS). A list of agency codes is available \href{https://help.waterdata.usgs.gov/code/agency_cd_query?fmt=html}{at this link}.}

\item{agency_name}{The name of the agency that is reporting the data.}

\item{monitoring_location_number}{Each monitoring location in the USGS data base has a unique 8- to 15-digit identification number. Monitoring location numbers are assigned \href{https://help.waterdata.usgs.gov/faq/sites/do-station-numbers-have-any-particular-meaning}{based on this logic}.}

\item{monitoring_location_name}{This is the official name of the monitoring location in the database. For well information this can be a district-assigned local number.}

\item{district_code}{The Water Science Centers (WSCs) across the United States use the FIPS state code as the district code. In some case, monitoring locations and samples may be managed by a water science center that is adjacent to the state in which the monitoring location actually resides. For example a monitoring location may have a district code of 30 which translates to Montana, but the state code could be 56 for Wyoming because that is where the monitoring location actually is located.}

\item{country_code}{The code for the country in which the monitoring location is located.}

\item{country_name}{The name of the country in which the monitoring location is located.}

\item{state_code}{State code. A \href{https://www2.census.gov/geo/docs/reference/state.txt}{two-digit ANSI code} (formerly FIPS code) as defined by the American National Standards Institute, to define States and equivalents. A three-digit ANSI code is used to define counties and county equivalents. \href{https://www.census.gov/library/reference/code-lists/ansi.html#states}{A lookup table is available.} The only countries with political subdivisions other than the US are Mexico and Canada. The Mexican states have US state codes ranging from 81-86 and Canadian provinces have state codes ranging from 90-98.}

\item{state_name}{The name of the state or state equivalent in which the monitoring location is located.}

\item{county_code}{The code for the county or county equivalent (parish, borough, etc.) in which the monitoring location is located. \href{https://help.waterdata.usgs.gov/code/county_query?fmt=html}{A list of codes is available.}}

\item{county_name}{The name of the county or county equivalent (parish, borough, etc.) in which the monitoring location is located. \href{https://help.waterdata.usgs.gov/code/county_query?fmt=html}{A list of codes is available.}}

\item{minor_civil_division_code}{Codes for primary governmental or administrative divisions of the county or county equivalent in which the monitoring location is located.}

\item{site_type_code}{A code describing the hydrologic setting of the monitoring location. \href{https://help.waterdata.usgs.gov/code/site_tp_query?fmt=html}{A list of codes is available.}}

\item{site_type}{A description of the hydrologic setting of the monitoring location. \href{https://help.waterdata.usgs.gov/code/site_tp_query?fmt=html}{A list of codes is available.}}

\item{hydrologic_unit_code}{The United States is divided and sub-divided into successively smaller hydrologic units which are classified into four levels: regions, sub-regions, accounting units, and cataloging units. The hydrologic units are arranged within each other, from the smallest (cataloging units) to the largest (regions). Each hydrologic unit is identified by a unique hydrologic unit code (HUC) consisting of two to eight digits based on the four levels of classification in the hydrologic unit system.}

\item{basin_code}{The Basin Code or "drainage basin code" is a two-digit code that further subdivides the 8-digit hydrologic-unit code. The drainage basin code is defined by the USGS State Office where the monitoring location is located.}

\item{altitude}{Altitude of the monitoring location referenced to the specified Vertical Datum.}

\item{altitude_accuracy}{Accuracy of the altitude, in feet. An accuracy of +/- 0.1 foot would be entered as “.1”. Many altitudes are interpolated from the contours on topographic maps; accuracies determined in this way are generally entered as one-half of the contour interval.}

\item{altitude_method_code}{Codes representing the method used to measure altitude. \href{https://help.waterdata.usgs.gov/code/alt_meth_cd_query?fmt=html}{A list of codes is available.}}

\item{altitude_method_name}{The name of the the method used to measure altitude. \href{https://help.waterdata.usgs.gov/code/alt_meth_cd_query?fmt=html}{A list of codes is available.}}

\item{vertical_datum}{The datum used to determine altitude and vertical position at the monitoring location. \href{https://help.waterdata.usgs.gov/code/alt_datum_cd_query?fmt=html}{A list of codes is available.}}

\item{vertical_datum_name}{The datum used to determine altitude and vertical position at the monitoring location. \href{https://help.waterdata.usgs.gov/code/alt_datum_cd_query?fmt=html}{A list of codes is available.}}

\item{horizontal_positional_accuracy_code}{Indicates the accuracy of the latitude longitude values. \href{https://help.waterdata.usgs.gov/code/coord_acy_cd_query?fmt=html}{A list of codes is available.}}

\item{horizontal_positional_accuracy}{Indicates the accuracy of the latitude longitude values. \href{https://help.waterdata.usgs.gov/code/coord_acy_cd_query?fmt=html}{A list of codes is available.}}

\item{horizontal_position_method_code}{Indicates the method used to determine latitude longitude values. \href{https://help.waterdata.usgs.gov/code/coord_meth_cd_query?fmt=html}{A list of codes is available.}}

\item{horizontal_position_method_name}{Indicates the method used to determine latitude longitude values. \href{https://help.waterdata.usgs.gov/code/coord_meth_cd_query?fmt=html}{A list of codes is available.}}

\item{original_horizontal_datum}{Coordinates are published in EPSG:4326 / WGS84 / World Geodetic System 1984. This field indicates the original datum used to determine coordinates before they were converted. \href{https://help.waterdata.usgs.gov/code/coord_datum_cd_query?fmt=html}{A list of codes is available.}}

\item{original_horizontal_datum_name}{Coordinates are published in EPSG:4326 / WGS84 / World Geodetic System 1984. This field indicates the original datum used to determine coordinates before they were converted. \href{https://help.waterdata.usgs.gov/code/coord_datum_cd_query?fmt=html}{A list of codes is available.}}

\item{drainage_area}{The area enclosed by a topographic divide from which direct surface runoff from precipitation normally drains by gravity into the stream above that point.}

\item{contributing_drainage_area}{The contributing drainage area of a lake, stream, wetland, or estuary monitoring location, in square miles. This item should be present only if the contributing area is different from the total drainage area. This situation can occur when part of the drainage area consists of very porous soil or depressions that either allow all runoff to enter the groundwater or traps the water in ponds so that rainfall does not contribute to runoff. A transbasin diversion can also affect the total drainage area.}

\item{time_zone_abbreviation}{A short code describing the time zone used by a monitoring location.}

\item{uses_daylight_savings}{A flag indicating whether or not a monitoring location uses daylight savings.}

\item{construction_date}{Date the well was completed.}

\item{aquifer_code}{Local aquifers in the USGS water resources data base are identified by a geohydrologic unit code (a three-digit number related to the age of the formation, followed by a 4 or 5 character abbreviation for the geologic unit or aquifer name). \href{https://help.waterdata.usgs.gov/faq/groundwater/local-aquifer-description}{Additional information is available at this link.}}

\item{national_aquifer_code}{National aquifers are the principal aquifers or aquifer systems in the United States, defined as regionally extensive aquifers or aquifer systems that have the potential to be used as a source of potable water. Not all groundwater monitoring locations can be associated with a National Aquifer. Such monitoring locations will not be retrieved using this search criteria. \href{https://help.waterdata.usgs.gov/code/nat_aqfr_query?fmt=html}{A list of National aquifer codes and names is available.}}

\item{aquifer_type_code}{Groundwater occurs in aquifers under two different conditions. Where water only partly fills an aquifer, the upper surface is free to rise and decline. These aquifers are referred to as unconfined (or water-table) aquifers. Where water completely fills an aquifer that is overlain by a confining bed, the aquifer is referred to as a confined (or artesian) aquifer. When a confined aquifer is penetrated by a well, the water level in the well will rise above the top of the aquifer (but not necessarily above land surface). \href{https://help.waterdata.usgs.gov/faq/groundwater/local-aquifer-description}{Additional information is available at this link.}}

\item{well_constructed_depth}{The depth of the finished well, in feet below land surface datum. Note: Not all groundwater monitoring locations have information on Well Depth. Such monitoring locations will not be retrieved using this search criteria.}

\item{hole_constructed_depth}{The total depth to which the hole is drilled, in feet below land surface datum. Note: Not all groundwater monitoring locations have information on Hole Depth. Such monitoring locations will not be retrieved using this search criteria.}

\item{depth_source_code}{A code indicating the source of water-level data. \href{https://help.waterdata.usgs.gov/code/water_level_src_cd_query?fmt=html}{A list of codes is available.}}

\item{properties}{A vector of requested columns to be returned from the query.
Available options are:
geometry, id, agency_code, agency_name, monitoring_location_number, monitoring_location_name, district_code, country_code, country_name, state_code, state_name, county_code, county_name, minor_civil_division_code, site_type_code, site_type, hydrologic_unit_code, basin_code, altitude, altitude_accuracy, altitude_method_code, altitude_method_name, vertical_datum, vertical_datum_name, horizontal_positional_accuracy_code, horizontal_positional_accuracy, horizontal_position_method_code, horizontal_position_method_name, original_horizontal_datum, original_horizontal_datum_name, drainage_area, contributing_drainage_area, time_zone_abbreviation, uses_daylight_savings, construction_date, aquifer_code, national_aquifer_code, aquifer_type_code, well_constructed_depth, hole_constructed_depth, depth_source_code.}

\item{bbox}{Only features that have a geometry that intersects the bounding
box are selected.The bounding box is provided as four or six numbers, depending
on whether the coordinate reference system includes a vertical axis (height or
depth). Coordinates are assumed to be in crs 4326. The expected format is a numeric
vector structured: c(xmin,ymin,xmax,ymax). Another way to think of it is c(Western-most longitude,
Southern-most latitude, Eastern-most longitude, Northern-most longitude).}

\item{limit}{The optional limit parameter is used to control the subset of the
selected features that should be returned in each page. The maximum allowable
limit is 10000. It may be beneficial to set this number lower if your internet
connection is spotty. The default (\code{NA}) will set the limit to the maximum
allowable limit for the service.}

\item{max_results}{The optional maximum number of rows to return. This value
must be less than the requested limit.}

\item{skipGeometry}{This option can be used to skip response geometries for
each feature. The returning object will be a data frame with no spatial
information.}
}
\description{
Description Location information is basic information about the monitoring location including the name, identifier, agency responsible for data collection, and the date the location was established. It also includes information about the type of location, such as stream, lake, or groundwater, and geographic information about the location, such as state, county, latitude and longitude, and hydrologic unit code (HUC).
}
\examples{
\dontshow{if (is_dataRetrieval_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

\donttest{
site <- "USGS-02238500"
site_info <- read_waterdata_monitoring_location(monitoring_location_id = site)

site_slim <- read_waterdata_monitoring_location(monitoring_location_id = site,
                             properties = c("monitoring_location_id",
                                            "state_name",
                                            "country_name"))
                                            
site_slim_no_sf_slim <- read_waterdata_monitoring_location(monitoring_location_id = site,
                                           properties = c("monitoring_location_id",
                                                          "state_name",
                                                          "country_name"), 
                                           skipGeometry = TRUE)

site_info_no_sf <- read_waterdata_monitoring_location(monitoring_location_id = site,
                                   skipGeometry = TRUE)

bbox_vals = c(-94.00, 35.0, -93.5, 35.5)
multi_site <- read_waterdata_monitoring_location(bbox = bbox_vals)
multi_site_n_100 <- read_waterdata_monitoring_location(bbox = bbox_vals,
                                                  max_results = 100)
multi_site_limit_100 <- read_waterdata_monitoring_location(bbox = bbox_vals,
                                                      limit = 100)
}
\dontshow{\}) # examplesIf}
}
