% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{graphic_data}
\alias{graphic_data}
\title{Draw a plot using the pararameters passed}
\usage{
graphic_data(type, data, columns, dataSelected = NULL, xlim = NULL,
  ylim = NULL, nClasses = NULL)
}
\arguments{
\item{type}{String with plot type}

\item{data}{Data.frame that contains the data to plot}

\item{columns}{Columns to represent in the plot}

\item{dataSelected}{Rows selected from the data}

\item{xlim}{Specifies the limit for x axis}

\item{ylim}{Specifies the limit for y axis}

\item{nClasses}{Split data in classes to draw in bloxplot}
}
\value{
plot
}
\description{
Draw a plot using the pararameters passed
}
\examples{
library(dataesgobr)
\donttest{
datasets <- search_by_title('atestados')
datasetsfiltered <- filter_by_title(datasets, "1999")
dataset <- load_dataset(datasetsfiltered)
download_data(dataset, "text/csv", TRUE, noconfirm = TRUE)
content <- load_data(file.path(tempdir(), "DB_HER_1999.csv"))
graph <- graphic_data("plot", content, "SEXO", xlim = 3, ylim = 2000)
graph
}
}
