# http://stackexchange.com/legal/terms-of-service
# 2. Network Content
# The Network and its contents are intended solely for the use of the Network Subscribers and may only be used in accordance with the terms of this Agreement. All materials displayed or performed on the Network, including, but not limited to text, graphics, logos, tools, photographs, images, illustrations, software or source code, audio and video, and animations (collectively, Content) (other than Content posted by Subscriber (Subscriber Content)) are the property of Stack Exchange and/or third parties and are protected by United States and international copyright laws.
# The Stack Exchange API shall be used solely pursuant to the terms of the API Terms of Use.
# All trademarks, service marks, and trade names are proprietary to Stack Exchange and/or third parties. Subscriber shall abide by all copyright notices, information, and restrictions contained in any Content accessed through the Services.
# The Network is protected by copyright as a collective work and/or compilation, pursuant to U.S. copyright laws, international conventions, and other copyright laws. Other than as expressly set forth in this Agreement, Subscriber may not copy, modify, publish, transmit, upload, participate in the transfer or sale of, reproduce (except as provided in this Section), create derivative works based on, distribute, perform, display, or in any way exploit, any of the Content, software, materials, or Services in whole or in part.
# Subscriber may download or copy the Content, and other items displayed on the Network for download, for personal use, provided that Subscriber maintains all copyright and other notices contained in such Content.
# From time to time, Stack Exchange may make available compilations of all the Subscriber Content on the Network (the Creative Commons Data Dump). The Creative Commons Data Dump is licensed under the Creative Commons Attribution Share Alike license. By downloading The Creative Commons Data Dump, You agree to be bound by the terms of that license.
# Any other downloading, copying, or storing any Content for other than personal, noncommercial use is expressly prohibited without prior written permission from Stack Exchange, or from the copyright holder identified in such Content's copyright notice. In the event You download software from the Network, the software, including any files, images incorporated in or generated by the software, and the data accompanying the software (collectively, the Software) is licensed to You by Stack Exchange or third party licensors for Your personal, noncommercial use, and no title to the Software shall be transferred to You. Stack Exchange or third party licensors retain full and complete title to the Software and all intellectual property rights therein.
#
# 3. Subscriber Content
# You agree that all Subscriber Content that You contribute to the Network is perpetually and irrevocably licensed to Stack Exchange under the Creative Commons Attribution Share Alike license. You grant Stack Exchange the perpetual and irrevocable right and license to use, copy, cache, publish, display, distribute, modify, create derivative works and store such Subscriber Content and to allow others to do so in any medium now known or hereinafter developed (Content License) in order to provide the Services, even if such Subscriber Content has been contributed and subsequently removed by You. Subscriber warrants, represents and agrees Subscriber has the right to grant Stack Exchange and the Network the rights set forth above. Subscriber represents, warrants and agrees that it will not contribute any Subscriber Content that (a) infringes, violates or otherwise interferes with any copyright or trademark of another party, (b) reveals any trade secret, unless Subscriber owns the trade secret or has the owners permission to post it, (c) infringes any intellectual property right of another or the privacy or publicity rights of another, (d) is libelous, defamatory, abusive, threatening, harassing, hateful, offensive or otherwise violates any law or right of any third party, (e) contains a virus, trojan horse, worm, time bomb or other computer programming routine or engine that is intended to damage, detrimentally interfere with, surreptitiously intercept or expropriate any system, data or information, or (f) remains posted after Subscriber has been notified that such Subscriber Content violates any of sections (a) to (e) of this sentence. Stack Exchange reserves the right to remove any Subscriber Content from the Network, re-post to the Network any Subscriber Content removed by any Subscriber or former Subscriber, suspend or terminate Subscribers right to use the Services at any time, or pursue any other remedy or relief available to Stack Exchange and/or the Network under equity or law, for any reason (including, but not limited to, upon receipt of claims or allegations from third parties or authorities relating to such Subscriber Content or if Stack Exchange is concerned that Subscriber may have breached the immediately preceding sentence), or for no reason at all.
# In the event that You post or otherwise use Subscriber Content outside of the Network or Services, whether such Subscriber Content was created by You or others, You agree that You will follow the attribution rules of the Creative Commons Attribution Share Alike license as follows:
# You will ensure that any such use of Subscriber Content visually displays or otherwise indicates the source of the Subscriber Content as coming from the Stack Exchange Network. This requirement is satisfied with a discreet text blurb, or some other unobtrusive but clear visual indication.
# You will ensure that any such Internet use of Subscriber Content includes a hyperlink directly to the original question on the source site on the Network (e.g., http://stackoverflow.com/questions/12345)
# You will ensure that any such use of Subscriber Content visually display or otherwise clearly indicate the author names for every question and answer so used.
# You will ensure that any such Internet use of Subscriber Content Hyperlink each author name directly back to his or her user profile page on the source site on the Network (e.g., http://stackoverflow.com/users/12345/username), directly to the Stack Exchange domain, in standard HTML (i.e. not through a Tinyurl or other such indirect hyperlink, form of obfuscation or redirection), without any nofollow command or any other such means of avoiding detection by search engines, and visible even with JavaScript disabled.

getRepChanges[userID_Integer] :=
 Module[{totalChanges},
  totalChanges = 
   "total" /. 
    Import["http://api.stackoverflow.com/1.1/users/" <> 
      ToString[userID] <> "/reputation?key=NgVJ4Y6vFkuF-oqI-eOvOw&fromdate=0&pagesize=1&page=1",
      "JSON"
    ];
    Join @@ 
    Table[
      "rep_changes" /. 
         Import["http://api.stackoverflow.com/1.1/users/" <> 
                ToString[userID] <> 
                "/reputation?key=NgVJ4Y6vFkuF-oqI-eOvOw&fromdate=0&pagesize=100&page=" 
                <> ToString[page], 
                "JSON"
         ],
         {page, 1, Ceiling[totalChanges/100]}
    ]
  ]

topAnswerers = 
  ({"display_name","user_id", "email_hash"} /. #) & /@ 
     ("user" /. 
      ("top_users" /. 
        Import[
          "http://api.stackoverflow.com/1.1/tags/mathematica/top-answerers/all-time",    
          "JSON"
        ]
       )
      )

topAnswerers = {#, #2, 
    Import["http://www.gravatar.com/avatar/" <> #3 <> ".jpg?s=36&d=identicon&d=identicon"]
    } & @@@ topAnswerers

repChangesTopUsers =
  Table[
    repChange = 
     ReleaseHold[
        (
         Hold[
           {
              DateList["on_date" + AbsoluteTime["January 1, 1970"]], 
             "positive_rep" - "negative_rep"
           }
         ] /. #
        ) & /@ getRepChanges[userID]
      ] // Sort;
      accRepChange = {repChange[[All, 1]],Accumulate[repChange[[All, 2]]]}\[Transpose],
      {userID, topAnswerers[[All, 2]]}
    ];
    
tagLookup[postID_Integer] :=
 Module[{im},
  im = Import["http://api.stackoverflow.com/1.1/questions/" <> ToString[postID],"JSON"];
  If[("questions" /. im) != {},
   First[("tags" /. ("questions" /. im))],
   im = Import["http://api.stackoverflow.com/1.1/answers/" <> ToString[postID],"JSON"];
   First[("tags" /. ("questions" /. Import["http://api.stackoverflow.com/1.1/questions/" <> 
          ToString[First["question_id" /. ("answers" /. im)]], "JSON"]))]
   ]
  ]

getQuestionIDs[tagName_String] := Module[{total},
  total = 
   "total" /. 
    Import["http://api.stackoverflow.com/1.1/questions?tagged=" <> 
      tagName <> "&pagesize=1", "JSON"];
  Join @@ 
   Table[("question_id" /. ("questions" /. 
        Import["http://api.stackoverflow.com/1.1/questions?key=NgVJ4Y6vFkuF-oqI-eOvOw&tagged=" <>
           tagName <> "&pagesize=100&page=" <> ToString[i], 
         "JSON"])), {i, 1, Ceiling[total/100]}]
  ]

getAnswerIDsFromQuestionID[questionID_Integer] :=
 Module[{total},
  total = 
   Import["http://api.stackoverflow.com/1.1/questions/" <> 
     ToString[questionID] <> "/answers?key=NgVJ4Y6vFkuF-oqI-eOvOw&pagesize=1", "JSON"];
  If[total === $Failed, Return[$Failed], total = "total" /. total]; 
  Join @@ Table[
    "answer_id" /. ("answers" /. 
       Import["http://api.stackoverflow.com/1.1/questions/" <> 
         ToString[questionID] <> "/answers?key=NgVJ4Y6vFkuF-oqI-eOvOw&pagesize=100&page=" <> 
         ToString[i], "JSON"]), {i, 1, Ceiling[total/100]}]
  ]

getAnswerIDsFromTag[tagName_String] :=
 Module[{},
  Join @@ (getAnswerIDsFromQuestionID /@ 
     Cases[getQuestionIDs[tagName], Except[$Failed]])
  ]
  
seStatsURL = "http://stackexchange.com/sites?view=list#traffic";

getSEStats[main_] := 
 Module[{url, fullXML, stackCreDate, stackQuestions, stackAnswers, 
   stackPerAns, stackUsers, stackVperD, stackQperD, stackName, 
   stackFavIco, stackURL, fullStackData, stackDays},

  (*Gather XML data from SE*)

  url = Import[seStatsURL, "XMLObject"];
  fullXML = 
   Table[url[[2]][[3]][[2]][[3]][[2]][[3]][[14]][[3]][[6]][[3]][[i]], \
{i, 2, 174, 2}];

  (*SE uses epoch time (jan 1 1970)*)

  stackCreDate = 
   Table[Cases[fullXML[[i]], 
     XMLElement[
      "input", {"type" -> "hidden", "name" -> "creation-date", 
       "value" -> ___}, ___], Infinity], {i, 1, Length[fullXML]}];
  stackCreDate = 
   ToExpression[
    Table[stackCreDate[[i]][[1]][[2]][[3]][[2]], {i, 1, 
      Length[fullXML]}]];

  stackDays = 
   Table[Ceiling[
     DateDifference[stackCreDate[[i]], Round[AbsoluteTime[]]] - 
      2], {i, 1, Length[fullXML]}];

  stackQuestions = 
   Table[Cases[fullXML[[i]], 
     XMLElement[
      "input", {"type" -> "hidden", "name" -> "questions", 
       "value" -> ___}, ___], Infinity], {i, 1, Length[fullXML]}];
  stackQuestions = 
   ToExpression[
    Table[stackQuestions[[i]][[1]][[2]][[3]][[2]], {i, 
      Length[fullXML]}]];

  stackAnswers = 
   Table[Cases[fullXML[[i]], 
     XMLElement[
      "input", {"type" -> "hidden", "name" -> "answers", 
       "value" -> ___}, ___], Infinity], {i, 1, Length[fullXML]}];
  stackAnswers = 
   ToExpression[
    Table[stackAnswers[[i]][[1]][[2]][[3]][[2]], {i, 
      Length[fullXML]}]];

  stackPerAns = 
   Table[Cases[fullXML[[i]], 
     XMLElement[
      "input", {"type" -> "hidden", "name" -> "percent-answered", 
       "value" -> ___}, ___], Infinity], {i, 1, Length[fullXML]}];
  stackPerAns = 
   ToExpression[
    Table[stackPerAns[[i]][[1]][[2]][[3]][[2]], {i, Length[fullXML]}]];

  stackUsers = 
   Table[Cases[fullXML[[i]], 
     XMLElement[
      "input", {"type" -> "hidden", "name" -> "users", 
       "value" -> ___}, ___], Infinity], {i, 1, Length[fullXML]}];
  stackUsers = 
   ToExpression[
    Table[stackUsers[[i]][[1]][[2]][[3]][[2]], {i, 
      Length[fullXML]}]];

  stackVperD = 
   Table[Cases[fullXML[[i]], 
     XMLElement[
      "input", {"type" -> "hidden", "name" -> "visits-per-day", 
       "value" -> ___}, ___], Infinity], {i, 1, Length[fullXML]}];
  stackVperD = 
   ToExpression[
    Table[stackVperD[[i]][[1]][[2]][[3]][[2]], {i, 
      Length[fullXML]}]];

  stackQperD = 
   Table[Cases[fullXML[[i]], 
     XMLElement[
      "input", {"type" -> "hidden", "name" -> "questions-per-day", 
       "value" -> ___}, ___], Infinity], {i, 1, Length[fullXML]}];
  stackQperD = 
   ToExpression[
    Table[stackQperD[[i]][[1]][[2]][[3]][[2]], {i, 
      Length[fullXML]}]];

  stackName = 
   Table[Cases[fullXML[[i]], 
     XMLElement[
      "input", {"type" -> "hidden", "name" -> "name", 
       "value" -> ___}, ___], Infinity], {i, 1, Length[fullXML]}];
  stackName = 
   Table[stackName[[i]][[1]][[2]][[3]][[2]], {i, Length[fullXML]}];


  (*Get URLs*)

  stackURL = 
   Table[fullXML[[i]][[3]][[2]][[2]][[2]][[2]], {i, 1, 
     Length[fullXML]}];

  (*Get favicons*)

  stackFavIco = 
   Table[fullXML[[i]][[3]][[3]][[3]][[2]][[2]][[2]][[2]], {i, 1, 
     Length[fullXML]}];

  fullStackData = 
   Table[{stackDays[[i]] - 25567, stackQuestions[[i]], 
     stackAnswers[[i]], stackPerAns[[i]], stackUsers[[i]], 
     stackVperD[[i]], stackQperD[[i]], stackName[[i]], stackURL[[i]], 
     stackFavIco[[i]]}, {i, 1, Length[fullXML]}]
  ]

stackData = getSEStats[seStatsURL];
  
  
pl = DateListLogPlot[
  Tooltip @@@ 
   Take[({repChangesTopUsers, Row /@ topAnswerers[[All, {3, 1}]]}\[Transpose]), 
    10], Joined -> True, Mesh -> None, ImageSize -> 1000, 
  PlotRange -> {All, {10, All}}, 
  BaseStyle -> {FontFamily -> "Arial-Bold", FontSize -> 16}, 
  DateTicksFormat -> {"MonthNameShort", " ", "Year"}, 
  GridLines -> {True, None}, 
  FrameLabel -> (Style[#, FontSize -> 18] & /@ {"Date", "Reputation", "Top-10 answerers", ""})]