% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuthenticationManager.R
\name{isAuthValid}
\alias{isAuthValid}
\alias{isAuthValid,AuthenticationManager-method}
\title{Verify authentication for a member node.}
\usage{
isAuthValid(.Object, ...)

\S4method{isAuthValid}{AuthenticationManager}(.Object, node)
}
\arguments{
\item{.Object}{An AuthenticationManager instance}

\item{...}{additional parameters}

\item{node}{The node object (MNode or CNode) that authentication is being checked for.}
}
\value{
A logical value: TRUE if authentication is valid, false if not.
}
\description{
The currently used DataONE client authentication method (either tokens or X.509 certificates)
is checked and verified for the specified node (either CN or MN). If an authentication token is available
via the R options facility, it will be used i.e. available via getOption("dataone_token").  However, 
authentication tokens can only be used for DataONE v2 or higher nodes. X.509 certificates can be used 
with DataONE v1 or higher nodes. 
See the \emph{"dataone"} vignette \emph{"dataone-overview"} for more information on authentication.
}
