/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.field.ContentTypeField;
import org.apache.james.mime4j.field.Field;
import org.apache.james.mime4j.parser.AbstractContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.util.CharArrayBuffer;
import org.apache.james.mime4j.util.CharsetUtil;
import org.apache.james.mime4j.util.MessageUtils;

public class Header {
    private List fields = new LinkedList();
    private Map fieldMap = new HashMap();

    public Header() {
    }

    public Header(InputStream is) throws MimeException, IOException {
        final MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler(new AbstractContentHandler(){

            public void endHeader() {
                parser.stop();
            }

            public void field(String fieldData) throws MimeException {
                Header.this.addField(Field.parse(fieldData));
            }
        });
        parser.parse(is);
    }

    public void addField(Field field) {
        LinkedList<Field> values = (LinkedList<Field>)this.fieldMap.get(field.getName().toLowerCase());
        if (values == null) {
            values = new LinkedList<Field>();
            this.fieldMap.put(field.getName().toLowerCase(), values);
        }
        values.add(field);
        this.fields.add(field);
    }

    public List getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Field getField(String name) {
        List l = (List)this.fieldMap.get(name.toLowerCase());
        if (l != null && !l.isEmpty()) {
            return (Field)l.get(0);
        }
        return null;
    }

    public List getFields(String name) {
        String lowerCaseName = name.toLowerCase();
        List l = (List)this.fieldMap.get(lowerCaseName);
        List results = l == null || l.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(l);
        return results;
    }

    public int removeFields(String name) {
        String lowerCaseName = name.toLowerCase();
        List removed = (List)this.fieldMap.remove(lowerCaseName);
        if (removed == null || removed.isEmpty()) {
            return 0;
        }
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!field.getName().equalsIgnoreCase(name)) continue;
            iterator.remove();
        }
        return removed.size();
    }

    public void setField(Field field) {
        String lowerCaseName = field.getName().toLowerCase();
        List l = (List)this.fieldMap.get(lowerCaseName);
        if (l == null || l.isEmpty()) {
            this.addField(field);
            return;
        }
        l.clear();
        l.add(field);
        int firstOccurrence = -1;
        int index = 0;
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Field f = (Field)iterator.next();
            if (f.getName().equalsIgnoreCase(field.getName())) {
                iterator.remove();
                if (firstOccurrence == -1) {
                    firstOccurrence = index;
                }
            }
            ++index;
        }
        this.fields.add(firstOccurrence, field);
    }

    public String toString() {
        CharArrayBuffer str = new CharArrayBuffer(128);
        Iterator it = this.fields.iterator();
        while (it.hasNext()) {
            str.append(it.next().toString());
            str.append("\r\n");
        }
        return str.toString();
    }

    public void writeTo(OutputStream out, int mode) throws IOException, MimeException {
        Charset charset = null;
        if (mode == 3) {
            ContentTypeField contentTypeField = (ContentTypeField)this.getField("Content-Type");
            if (contentTypeField == null) {
                charset = MessageUtils.DEFAULT_CHARSET;
            } else {
                String contentTypeFieldCharset = contentTypeField.getCharset();
                charset = contentTypeField != null && contentTypeFieldCharset != null ? CharsetUtil.getCharset(contentTypeFieldCharset) : MessageUtils.ISO_8859_1;
            }
        } else {
            charset = MessageUtils.DEFAULT_CHARSET;
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, charset), 8192);
        Iterator it = this.fields.iterator();
        while (it.hasNext()) {
            Field field = (Field)it.next();
            String fs = field.toString();
            if (mode == 2 && !MessageUtils.isASCII(fs)) {
                throw new MimeException("Header '" + fs + "' violates RFC 822");
            }
            writer.write(fs);
            writer.write("\r\n");
        }
        writer.write("\r\n");
        writer.flush();
    }
}

