% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp_to_code.R
\name{dp_to_code}
\alias{dp_to_code}
\title{Recode a variable to \code{code} using the associated categories}
\usage{
dp_to_code(x, categorieslist = dp_categorieslist(x), ..., warn = FALSE)
}
\arguments{
\item{x}{the variable to recode}

\item{categorieslist}{a \code{data.frame} with the categories as a
\code{data.frame}.}

\item{...}{passed on to \code{\link[codelist]{as.codelist}}.}

\item{warn}{give a warning when there is no code list.}
}
\value{
Returns a '\link[codelist]{code}' object or \code{x} when no categories
could be found (\code{categorieslist = NULL}).
}
\description{
Recode a variable to \code{code} using the associated categories
}
\details{
Uses the \code{\link[codelist]{code}} method from the  'codelist' package.
This package therefore needs to be installed. See the documentation of that
package for how to work with 'code' objects.
}
\examples{
fn <- system.file("examples/iris", package = "datapackage")
dp <- open_datapackage(fn)
dta <- dp |> dp_get_data("complex", convert_categories = "no")
dp_to_code(dta$factor1)

dp |> dp_get_data("complex", convert_categories = "dp_to_code")


}
\seealso{
An alternative is the \code{\link{dp_to_factor}} function to convert to
regular R factor.
}
