% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acc_varcomp.R
\name{acc_varcomp}
\alias{acc_varcomp}
\title{Utility function to compute model-based ICC depending on the (statistical) data type}
\usage{
acc_varcomp(
  resp_vars = NULL,
  group_vars = NULL,
  co_vars = NULL,
  study_data,
  label_col,
  item_level = "item_level",
  min_obs_in_subgroup = 10,
  min_subgroups = 5,
  cut_off_linear_model_for_ord = 10,
  meta_data = item_level,
  meta_data_v2
)
}
\arguments{
\item{resp_vars}{\link{variable} the name of the measurement variable}

\item{group_vars}{\link{variable} the name of the examiner, device or
reader variable}

\item{co_vars}{\link{variable list} a vector of covariables, e.g. age and sex,
for adjustment}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{min_obs_in_subgroup}{\link{integer} from=0. This optional argument specifies
the minimum number of observations that is
required to include a subgroup (level) of the
\code{group_var} in the analysis. Subgroups with less
observations are excluded.}

\item{min_subgroups}{\link{integer} from=0. This optional argument specifies
the minimum number of subgroups (level) of the
\code{group_var} that is required to run the
analysis. If there are less subgroups, the
analysis is not conducted.}

\item{cut_off_linear_model_for_ord}{\link{integer} from=0. This optional argument
specifies the minimum number of observations for
individual levels of an ordinal outcome
(\code{resp_var}) that is required to run a linear
mixed effects model instead of a mixed effects
ordered regression (i.e., a cut-off value above
which linear models are considered a good
approximation). The argument can be set to
\code{NULL} if ordered regression models are
preferred for ordinal data in any case.}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}
}
\value{
The function returns two data frames, 'SummaryTable' and
'SummaryData', that differ only in the names of the columns.
}
\description{
This function is still under construction. It is designed to run for any
statistical data type as follows:
\itemize{
\item Variables with only two distinct values will be modeled by mixed effects
logistic regression.
\item Nominal variables will be transformed to binary variables. This can be
user-specified using the metadata columns \code{RECODE_CASES} and/or
\code{RECODE_CONTROL}. Otherwise, the most frequent category will be assigned
to cases and the remaining categories to control. As for other binary
variables, the ICC will be computed using a mixed effects logistic
regression.
\item Ordinal variables will be analyzed by linear mixed effects models, if
every level of the variable has at least as many observations as
specified in the argument \code{cut_off_linear_model_for_ord}. Otherwise, the
data will be modeled by a mixed effects ordered regression, if the
package \code{ordinal} is available.
\item Metric variables with integer values are analyzed by linear mixed
effects models.
\item For variables with data type \code{float}, the existing implementation
\code{acc_varcomp} is called, which also uses linear mixed effects models.
}

\link{Indicator}
}
\details{
Not yet described
}
