% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_get_labels.R
\name{prep_get_labels}
\alias{prep_get_labels}
\title{Fetch a label for a variable based on its purpose}
\usage{
prep_get_labels(
  resp_vars,
  item_level = "item_level",
  label_col,
  max_len = MAX_LABEL_LEN,
  label_class = c("SHORT", "LONG"),
  label_lang = getOption("dataquieR.lang", ""),
  resp_vars_are_var_names_only = FALSE,
  resp_vars_match_label_col_only = FALSE,
  meta_data = item_level,
  meta_data_v2,
  force_label_col = getOption("dataquieR.force_label_col",
    dataquieR.force_label_col_default)
)
}
\arguments{
\item{resp_vars}{\link{variable list} the variable names to fetch for}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{max_len}{\link{integer} the maximum label length to return, if not possible
w/o causing ambiguous labels, the labels may still
be longer}

\item{label_class}{\link{enum} SHORT | LONG. which sort of label
according to the metadata model should be returned}

\item{label_lang}{\link{character} optional language suffix, if available in
the metadata. Can be controlled by the option
\code{dataquieR.lang}.}

\item{resp_vars_are_var_names_only}{\link{logical} If \code{TRUE}, do not use
other labels than \link{VAR_NAMES}
for finding \code{resp_vars} in
\code{meta_data}}

\item{resp_vars_match_label_col_only}{\link{logical} If \code{TRUE}, do not use
other labels than those,
referred by \code{label_col}
for finding \code{resp_vars} in
\code{meta_data}}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}

\item{force_label_col}{\link{enum} auto | FALSE | TRUE. if \code{TRUE}, always use
labels according \code{label_col}, \code{FALSE} means
use labels matching best the function's
requirements, \code{auto} means \code{FALSE}, if in a
\code{dq_report()} and \code{TRUE}, otherwise.}
}
\value{
\link{character} suitable labels for each \code{resp_vars}, names of this
vector are \link{VAR_NAMES}
}
\description{
Fetch a label for a variable based on its purpose
}
\examples{
\dontrun{
prep_load_workbook_like_file("meta_data_v2")
prep_get_labels("SEX_0", label_class = "SHORT", max_len = 2)
}
}
