% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_expand_codes.R
\name{prep_expand_codes}
\alias{prep_expand_codes}
\title{Expand code labels across variables}
\usage{
prep_expand_codes(
  item_level = "item_level",
  suppressWarnings = FALSE,
  mix_jumps_and_missings = FALSE,
  meta_data_v2,
  meta_data = item_level
)
}
\arguments{
\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{suppressWarnings}{\link{logical} show warnings, if labels are expanded}

\item{mix_jumps_and_missings}{\link{logical} ignore the class of the codes for
label expansion, i.e., use missing code labels
as jump code labels, if the values are the
same.}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}
}
\value{
\link{data.frame} an updated metadata data frame.
}
\description{
Code labels are copied from other
variables, if the code is the same and the
label is set only for some variables
}
\examples{
\dontrun{
meta_data <- prep_get_data_frame("meta_data")
meta_data$JUMP_LIST[meta_data$VAR_NAMES == "v00003"] <- "99980 = NOOP"
md <- prep_expand_codes(meta_data)
md$JUMP_LIST
md$MISSING_LIST
md <- prep_expand_codes(meta_data, mix_jumps_and_missings = TRUE)
md$JUMP_LIST
md$MISSING_LIST
meta_data <- prep_get_data_frame("meta_data")
meta_data$MISSING_LIST[meta_data$VAR_NAMES == "v00003"] <- "99980 = NOOP"
md <- prep_expand_codes(meta_data)
md$JUMP_LIST
md$MISSING_LIST
}
}
