% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{torchwood_episodes}
\alias{torchwood_episodes}
\title{List of Torchwood episodes}
\format{
This data frame contains the following columns:
\describe{
\item{\code{season_number}}{Season number}
\item{\code{serial_title}}{Serial title if available}
\item{\code{story_number}}{Story number}
\item{\code{episode_number}}{Episode number in season}
\item{\code{episode_title}}{Episode Title}
\item{\code{first_aired}}{Date the episode first aired in the U.K.}
\item{\code{production_code}}{Episode's production code if available}
\item{\code{uk_viewers}}{Number of U.K. viewers (millions)}
\item{\code{duration}}{Episode's duration in minutes}
}
}
\source{
\url{https://en.wikipedia.org/wiki/List_of_Torchwood_episodes}
}
\usage{
torchwood_episodes
}
\description{
List of all episodes from the Torchwood series (2006-2011)
}
\examples{
library(dplyr)
torchwood_episodes \%>\%
    filter(uk_viewers >= 5)
}
\keyword{datasets}
