% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RocCurve.R
\name{GetRocCurve}
\alias{GetRocCurve}
\title{Retrieve ROC curve data for a model for a particular data partition (see DataPartition)}
\usage{
GetRocCurve(model, source = DataPartition$VALIDATION,
  fallbackToParentInsights = FALSE)
}
\arguments{
\item{model}{dataRobotModel. A DataRobot model object like that returned by \code{GetModel}.}

\item{source}{character. The data partition for which data would be returned. Default is
\code{DataPartition$VALIDATION}. See \code{DataPartition} for details.}

\item{fallbackToParentInsights}{logical. If TRUE, this will return the lift chart data for the
model's parent if the lift chart is not available for the model and the model has a parent
model.}
}
\value{
list with the following components:
\itemize{
  \item source. Character: data partition for which ROC curve data is returned
    (see DataPartition).
  \item negativeClassPredictions. Numeric: example predictions for the negative class.
  \item rocPoints. data.frame: each row represents pre-calculated metrics (accuracy,
    f1_score, false_negative_score, true_negative_score, true_positive_score,
    false_positive_score, true_negative_rate, false_positive_rate, true_positive_rate,
    matthews_correlation_coefficient, positive_predictive_value, negative_predictive_value,
    threshold) associated with different thresholds for the ROC curve.
  \item positiveClassPredictions. Numeric: example predictions for the positive class.
}
}
\description{
Retrieve ROC curve data for a model for a particular data partition (see DataPartition)
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  GetRocCurve(model)
}
}
