% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Featurelists.R
\name{GetFeaturelist}
\alias{GetFeaturelist}
\title{Retrieve a specific featurelist from a DataRobot project}
\usage{
GetFeaturelist(project, featurelistId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{featurelistId}{Unique alphanumeric identifier for the featurelist
to be retrieved.}
}
\value{
A list with the following elements describing the requested featurelist:
\itemize{
  \item featurelistId character. The unique alphanumeric identifier for the featurelist.
  \item projectId character. The project to which the featurelist belongs.
  \item features character. The names of the variables included in the featurelist.
  \item name character. The name of the featurelist.
  \item created character. A timestamp of when the featurelist was created.
  \item isUserCreated logical. Whether or not the featurelist was created by a user
    (as opposed to DataRobot automation).
  \item numModels numeric. The number of models that currently use this featurelist.
}
}
\description{
This function returns information about and the contents
of a specified featurelist from a specified project.
}
\details{
DataRobot featurelists define the variables from the modeling
dataset used in fitting each project model. In most cases,
the same featurelist is used in fitting all project models,
but models can be fit using alternative featurelists using the
RequestNewModel function. To do this, featurelistId is required,
and this is one of the elements returned by the GetFeaturelist
function.

DataRobot featurelists define the variables from the modeling
dataset used in fitting each project model. In most cases, the
same featurelist is used in fitting all project models, but models
can be fit using alternative featurelists using the RequestNewModel
function. To do this, featurelistId is required, and this is one of
the elements returned by the GetFeaturelist function.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  featureList <- CreateFeaturelist(projectId, "myFeaturelist", c("feature1", "feature2"))
  featurelistId <- featureList$featurelistId
  GetFeaturelist(projectId, featurelistId)
}
}
