% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Features.R
\name{CreateDerivedFeatures}
\alias{CreateDerivedFeatureAsCategorical}
\alias{CreateDerivedFeatureAsNumeric}
\alias{CreateDerivedFeatureAsText}
\alias{CreateDerivedFeatures}
\title{Derived Features}
\usage{
CreateDerivedFeatureAsCategorical(project, parentName, name = NULL,
  dateExtraction = NULL, replacement = NULL, maxWait = 60)

CreateDerivedFeatureAsText(project, parentName, name = NULL,
  dateExtraction = NULL, replacement = NULL, maxWait = 60)

CreateDerivedFeatureAsNumeric(project, parentName, name = NULL,
  dateExtraction = NULL, replacement = NULL, maxWait = 60)
}
\arguments{
\item{project}{Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this identifier.}

\item{parentName}{The name of the parent feature.}

\item{name}{The name of the new feature.}

\item{dateExtraction}{dateExtraction: The value to extract from the date column:
'year', 'yearDay', 'month', 'monthDay', 'week', or 'weekDay'. Required for transformation of a
date column. Otherwise must not be provided.}

\item{replacement}{The replacement in case of a failed transformation. Optional.}

\item{maxWait}{The maximum time (in seconds) to wait for feature creation.}
}
\value{
Details for the created feature; same schema as the object returned from GetFeatureInfo.
}
\description{
These functions request that new features be created as transformations of existing
features and wait for the new feature to be created.
}

