% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_definition.R
\name{var_definition}
\alias{var_definition}
\alias{var_definition<-}
\alias{definition_attribute}
\alias{get_definition_attribute}
\alias{set_definition_attribute}
\alias{definition_attribute<-}
\title{Get / set a definition for a vector or a dataset}
\usage{
var_definition(x, ...)

var_definition(x) <- value

definition_attribute(x)

get_definition_attribute(x)

set_definition_attribute(x, value)

definition_attribute(x) <- value
}
\arguments{
\item{x}{a vector}

\item{...}{Further parameters for inheritance, not in use.}

\item{value}{a character string or \code{NULL} to remove the definition of measure.}
}
\value{
The (linked) definition of the meaning of the data contained by a
vector constructed with \code{\link{defined}}.
}
\description{
Get / set a definition for a vector or a dataset
}
\details{
\code{get_variable_definitions()} is identical to \code{var_definition()}.
}
\examples{
small_country_dataset <- dataset_df(
  country_name = defined(c("Andorra", "Lichtenstein"), label  = "Country"),
  gdp = defined(c(3897, 7365),
                      label = "Gross Domestic Product",
                      unit = "million dollars")
)
var_definition(small_country_dataset$country_name) <- "http://data.europa.eu/bna/c_6c2bb82d"
var_definition(small_country_dataset$country_name)
# To remove a definition of measure
var_definition(small_country_dataset$country_name) <- NULL
}
