% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sinasc_nv_bruf.R
\name{sinasc_nv_bruf}
\alias{sinasc_nv_bruf}
\title{Scrapes SINASC data from regions}
\usage{
sinasc_nv_bruf(linha = "Região", coluna = "Não ativa",
conteudo = 1, periodo = "last", regiao = "all", unidade_da_federacao = "all",
  local_ocorrencia = "all", idade_da_mae = "all", instrucao_da_mae = "all",
  estado_civil_mae = "all", duracao_gestacao = "all", tipo_de_gravidez = "all",
  tipo_de_parto = "all", consult_pre_natal = "all", sexo = "all",
  cor_raca = "all", apgar_1_minuto = "all", apgar_5_minuto = "all",
  peso_ao_nascer = "all", anomalia_congenita = "all", tipo_anomal_congen = "all")
}
\arguments{
\item{linha}{A character describing which element will be displayed in the rows of the data.frame. Defaults to "Município".}

\item{coluna}{A character describing which element will be displayed in the columns of the data.frame. Defaults to "Não ativa".}

\item{conteudo}{A character of length = 1 with the state's acronym of interest.}

\item{periodo}{A character vector describing the period of data. Defaults to the last available.}

\item{regiao}{"all" or a numeric vector with the IBGE's region codes to filter the data. Defaults to "all".}

\item{unidade_da_federacao}{"all" or a numeric vector with the IBGE's state codes to filter the data. Defaults to "all".}

\item{local_ocorrencia}{"all" or a character vector with the place of ocurrence to filter the data. Defaults to "all".}

\item{idade_da_mae}{"all" or a character vector with the age range (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{instrucao_da_mae}{"all" or a character vector with the mother's instruction (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{estado_civil_mae}{"all" or a character vector with the marital status of the mother (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{duracao_gestacao}{"all" or a character vector with the marital status of the mother (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{tipo_de_gravidez}{"all" or a character vector with the type of pregnancy (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{tipo_de_parto}{"all" or a character vector with the Parturition type (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{consult_pre_natal}{"all" or a character vector with the amount of prenatal consultation  (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{sexo}{"all" or a character vector with the gender (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{cor_raca}{"all" or a character vector with the color/race (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{apgar_1_minuto}{"all" or a character vector with the value of the apgar exam of the first minute (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{apgar_5_minuto}{"all" or a character vector with the value of the apgar exam of the fifth minute (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{peso_ao_nascer}{"all" or a character vector with the birth weight (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{anomalia_congenita}{"all" or a character vector with the indicative of congenital anomaly (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{tipo_anomal_congen}{"all" or a character vector with the congenital anomaly type (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}
}
\value{
The function returns a data frame printed by parameters input.
}
\description{
This function allows the user to retrive data from
SINASC database much in the same way that is done
by the online portal. The argument options refer to
data focused on the regions and states.
}
\examples{
\dontrun{
## Requesting data from Midwest region
sinasc_nv_bruf(region = 5)
}

}
\seealso{
\code{\link{sinasc_nv_uf}}
}
\author{
Renato Prado Siqueira \email{<rpradosiqueira@gmail.com>}
}
\keyword{SINASC}
\keyword{datasus}
