% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_ingested}
\alias{is_ingested}
\title{Identify if file is an ingested file}
\usage{
is_ingested(
  x,
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  ...
)
}
\arguments{
\item{x}{A numeric fileid or file-specific DOI}

\item{key}{A character string specifying a Dataverse server API key. If one
is not specified, functions calling authenticated API endpoints will fail.
Keys can be specified atomically or globally using
\code{Sys.setenv("DATAVERSE_KEY" = "examplekey")}.}

\item{server}{A character string specifying a Dataverse server.
Multiple Dataverse installations exist, with \code{"dataverse.harvard.edu"} being the
most major. The server can be defined each time within a function, or it can
be set as a default via an environment variable. To set a default, run
\code{Sys.setenv("DATAVERSE_SERVER" = "dataverse.harvard.edu")}
or add \verb{DATAVERSE_SERVER = "dataverse.harvard.edu} in one's \code{.Renviron}
file (\code{usethis::edit_r_environ()}), with the appropriate domain as its value.}

\item{...}{Arguments passed on to \code{get_file} (no effect here)}
}
\value{
Length-1 logical, \code{TRUE} if it is ingested and \code{FALSE} otherwise
}
\description{
Identify if file is an ingested file
}
\examples{
\dontrun{
# https://demo.dataverse.org/file.xhtml?persistentId=doi:10.70122/FK2/PPIAXE
# nlsw88.tab
is_ingested(x = "doi:10.70122/FK2/PPIAXE/MHDB0O",
            server = "demo.dataverse.org")
is_ingested(x = 1734017,
            server = "demo.dataverse.org")

# nlsw88_rds-export.rds
is_ingested(x = "doi:10.70122/FK2/PPIAXE/SUCFNI",
            server = "demo.dataverse.org")
is_ingested(x = 1734016,
            server = "demo.dataverse.org")
}
}
