% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/native_user.R
\name{get_user_key}
\alias{get_user_key}
\title{Get API Key}
\usage{
get_user_key(user, password, server = Sys.getenv("DATAVERSE_SERVER"), ...)
}
\arguments{
\item{user}{A character vector specifying a Dataverse server username.}

\item{password}{A character vector specifying the password for this user.}

\item{server}{The Dataverse instance. See \code{get_file}.}

\item{...}{Additional arguments passed to an HTTP request function,
such as \code{\link[httr]{GET}}, \code{\link[httr]{POST}}, or
\code{\link[httr]{DELETE}}. See \code{\link{use_cache}} for details
on how the \emph{R} dataverse package uses disk and session caches to
improve network performance.}
}
\value{
A list.
}
\description{
Get a user's API key
}
\details{
Use a Dataverse server's username and password login to obtain an
API key for the user. This can be used if one does not yet have an API key,
or desires to reset the key. This function does not require an API \code{key}
argument to authenticate, but \code{server} must still be specified.
}
\examples{
\dontrun{
 # Replace Username and password with personal login
 get_user_key("username", "password", server = "dataverse.harvard.edu")
}
}
