% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_file.R, R/get_file_by_id.R
\name{get_file}
\alias{get_file}
\alias{get_file_by_name}
\alias{get_file_by_id}
\alias{get_file_by_doi}
\title{Download dataverse file as a raw binary}
\usage{
get_file(
  file,
  dataset = NULL,
  format = c("original", "bundle"),
  vars = NULL,
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  original = TRUE,
  ...
)

get_file_by_name(
  filename,
  dataset,
  format = c("original", "bundle"),
  vars = NULL,
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  original = TRUE,
  ...
)

get_file_by_id(
  fileid,
  dataset = NULL,
  format = c("original", "bundle"),
  vars = NULL,
  original = TRUE,
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  ...
)

get_file_by_doi(
  filedoi,
  dataset = NULL,
  format = c("original", "bundle"),
  vars = NULL,
  original = TRUE,
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  ...
)
}
\arguments{
\item{file}{An integer specifying a file identifier; or a vector of integers
specifying file identifiers; or, if used with the prefix \code{"doi:"}, a
character with the file-specific DOI; or, if used without the prefix, a
filename accompanied by a dataset DOI in the \code{dataset} argument, or an object of
class \dQuote{dataverse_file} as returned by \code{\link{dataset_files}}.}

\item{dataset}{A character specifying a persistent identification ID for a dataset,
for example \code{"doi:10.70122/FK2/HXJVJU"}. Alternatively, an object of class
\dQuote{dataverse_dataset} obtained by \code{dataverse_contents()}.}

\item{format}{A character string specifying a file format for download.
by default, this is \dQuote{original} (the original file format). If \code{NULL},
no query is added, so ingested files are returned in their ingested TSV form.
For tabular datasets, the option \dQuote{bundle} downloads the bundle
of the original and archival versions, as well as the documentation.
See \url{https://guides.dataverse.org/en/latest/api/dataaccess.html} for details.}

\item{vars}{A character vector specifying one or more variable names, used to
extract a subset of the data.}

\item{key}{A character string specifying a Dataverse server API key. If one
is not specified, functions calling authenticated API endpoints will fail.
Keys can be specified atomically or globally using
\code{Sys.setenv("DATAVERSE_KEY" = "examplekey")}.}

\item{server}{A character string specifying a Dataverse server. There are
multiple Dataverse installations, but the defaults is to use the Harvard
Dataverse (\code{server = "dataverse.harvard.edu"}). This can be modified atomically
or globally using \code{Sys.setenv("DATAVERSE_SERVER" = "dataverse.example.com")}.}

\item{original}{A logical, defaulting to TRUE. If a ingested (.tab) version is
available, download the original version instead of the ingested? If there was
no ingested version, is set to NA. Note in \verb{get_dataframe_*},
\code{original} is set to FALSE by default. Either can be changed.}

\item{...}{Additional arguments passed to an HTTP request function, such as
\code{\link[httr]{GET}}, \code{\link[httr]{POST}}, or
\code{\link[httr]{DELETE}}.}

\item{filename}{Filename of the dataset, with file extension as shown in Dataverse
(for example, if nlsw88.dta was the original but is displayed as the ingested
nlsw88.tab, use the ingested version.)}

\item{fileid}{A numeric ID internally used for \code{get_file_by_id}}

\item{filedoi}{A DOI for a single file (not the entire dataset), of the form
\code{"10.70122/FK2/PPIAXE/MHDB0O"} or \code{"doi:10.70122/FK2/PPIAXE/MHDB0O"}}
}
\value{
\code{get_file} returns a raw vector (or list of raw vectors,
if \code{length(file) > 1}), which can be saved locally with the \code{writeBin}
function.  To load datasets into the R environment dataframe, see
\link{get_dataframe_by_name}.
}
\description{
Download Dataverse File(s). \verb{get_file_*}
functions return a raw binary file, which cannot be readily analyzed in R.
To use the objects as dataframes, see the \verb{get_dataset_*} functions at
\link{get_dataset} instead.
}
\details{
This function provides access to data files from a Dataverse entry.
\code{get_file} is a general wrapper,
and can take either dataverse objects, file IDs, or a filename and dataverse.
Internally, all functions download each file by \code{get_file_by_id}.
\code{get_file_by_name} is a shorthand for running \code{get_file} by
specifying a file name (\code{filename}) and dataset (\code{dataset}).
\code{get_file_by_doi} obtains a file by its file DOI, bypassing the
\code{dataset} argument.
}
\examples{
\dontrun{

# 1. Using filename and dataverse
f1 <- get_file_by_name(
  filename = "nlsw88.tab",
  dataset  = "10.70122/FK2/PPIAXE",
  server   = "demo.dataverse.org"
)

# 2. Using file DOI
f2 <- get_file_by_doi(
  filedoi  = "10.70122/FK2/PPIAXE/MHDB0O",
  server   = "demo.dataverse.org"
)

# 3. Two-steps: Find ID from get_dataset
d3 <- get_dataset("doi:10.70122/FK2/PPIAXE", server = "demo.dataverse.org")
f3 <- get_file(d3$files$id[1], server = "demo.dataverse.org")

# 4. Retrieve multiple raw data in list
f4_vec <- get_dataset(
  "doi:10.70122/FK2/PPIAXE",
  server = "demo.dataverse.org"
)$files$id

f4 <- get_file(f4_vec, server = "demo.dataverse.org")
length(f4)

# Write binary files
# (see `get_dataframe_by_name` to load in environment)
# The appropriate file extension needs to be assigned by the user.
writeBin(f1, "nlsw88.dta")
writeBin(f2, "nlsw88.dta")

writeBin(f4[[1]], "nlsw88.rds") # originally a rds file
writeBin(f4[[2]], "nlsw88.dta") # originally a dta file
}

}
\seealso{
To load the objects as datasets \link{get_dataframe_by_name}.
}
