% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_date.R
\name{fix_date}
\alias{fix_date}
\title{Convert improperly formatted date to R's Date class}
\usage{
fix_date(date, day.impute = 1, month.impute = 7)
}
\arguments{
\item{date}{Character to be converted to R's date class.}

\item{day.impute}{Integer. Day of the month to be imputed if not available.
defaults to 1.}

\item{month.impute}{Integer. Month to be be imputed if not available.
Defaults to 7 (July)}
}
\value{
An object belonging to R's built in \code{Date} class.
}
\description{
Converts a single improperly formatted date to R's Date class
Supports numerous separators including /,- or white space.
Supports all-numeric, abbreviation or long-hand month notation. Where
day of the month has not been supplied, the first day of the month is
imputed. When day, month and year is given either DMY or YMD is assumed; the
US system of MDY is not supported.
}
\examples{
bad.date <- "02 03 2021"
fixed.date <- fix_date(bad.date)
}
\seealso{
\link{fix_dates} Similar to \code{fix_date()} except is applicable
to columns of a dataframe.
}
