% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_phylo.R
\name{patristic_matrix_to_phylo}
\alias{patristic_matrix_to_phylo}
\title{Convert a patristic matrix to a \code{phylo} object.}
\usage{
patristic_matrix_to_phylo(
  patristic_matrix,
  clustering_method = "nj",
  fix_negative_brlen = TRUE,
  fixing_method = 0,
  ultrametric = TRUE,
  variance_matrix = NULL
)
}
\arguments{
\item{patristic_matrix}{A patristic matrix}

\item{clustering_method}{A character vector indicating the method to construct
the tree. Options are:
\describe{
\item{nj}{Neighbor-Joining method applied with \code{\link[ape:nj]{ape::nj()}}.}
\item{upgma}{Unweighted Pair Group Method with Arithmetic Mean method applied
with \code{\link[phangorn:upgma]{phangorn::upgma()}}.}
\item{bionj}{An improved version of the Neighbor-Joining method applied with
\code{\link[ape:bionj]{ape::bionj()}}.}
\item{triangle}{Triangles method applied with \code{\link[ape:triangMtd]{ape::triangMtd()}}}
\item{mvr}{Minimum Variance Reduction method applied with \code{\link[ape:mvr]{ape::mvr()}}.}
}}

\item{fix_negative_brlen}{Boolean indicating whether to fix negative branch
lengths in resulting tree or not. Default to \code{TRUE}.}

\item{fixing_method}{A character vector specifying the method to fix branch lengths: "bladj", "mrbayes" or a number to be assigned to all branches meeting fixing_criterion}

\item{ultrametric}{Boolean indicating whether to force ultrametric or not.}

\item{variance_matrix}{A variance matrix from a \code{datelifeResult} object,
usually an output from \code{\link[=datelife_result_variance_matrix]{datelife_result_variance_matrix()}}.
Only used if \code{clustering_method = "mvr"}.}
}
\value{
A rooted \code{phylo} object.
}
\description{
U\code{patristic_matrix_to_phylo} us used inside \code{\link[=summarize_datelife_result]{summarize_datelife_result()}}.
}
\details{
We might add the option to insert a function as \code{clustering_method} in the future.
Before, we had hard-coded the function to try Neighbor-Joining (NJ) first; if it
errors, it will try UPGMA.
Now, it uses NJ for a "phylo_all" summary, and we are using our own algorithm to
get a tree from a summary matrix.
}
