% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_daymet.r
\name{download_daymet}
\alias{download_daymet}
\title{Function to download single location 'Daymet' data}
\usage{
download_daymet(site = "Daymet", lat = 36.0133, lon = -84.2625,
  start = 2000, end = as.numeric(format(Sys.time(), "\%Y")) - 2,
  path = tempdir(), internal = TRUE, silent = FALSE, force = FALSE)
}
\arguments{
\item{site}{the site name.}

\item{lat}{latitude (decimal degrees)}

\item{lon}{longitude (decimal degrees)}

\item{start}{start of the range of years over which to download data}

\item{end}{end of the range of years over which to download data}

\item{path}{set path where to save the data
if internal = FALSE (default = NULL)}

\item{internal}{\code{TRUE} or \code{FALSE}, if \code{TRUE} returns a list to the R workspace if
\code{FALSE} puts the downloaded data into the current working directory
(default = \code{FALSE})}

\item{silent}{\code{TRUE} or \code{FALSE} (default), to provide verbose output}

\item{force}{\code{TRUE} or \code{FALSE} (default),
override the conservative end year setting}
}
\value{
Daymet data for a point location, returned to the R workspace or
written to disk as a csv file.
}
\description{
Function to download single location 'Daymet' data
}
\examples{

\dontrun{
# The following commands download and process Daymet data
# for 10 years of the >30 year of data available since 1980.
daymet_data <- download_daymet("testsite_name",
                lat = 36.0133,
                lon = -84.2625,
                start = 2000,
                end = 2010,
                internal = TRUE)

# We can now quickly calculate and plot
# daily mean temperature. Also, take note of
# the weird format of the header. This format 
# is not altered as to keep compatibility
# with other ways of acquiring Daymet data
# through the ORNL DAAC website.

# The below command lists headers of 
# the downloaded nested list.
# This data includes information on the site
# location etc. The true climate data is stored
# in the "data" part of the nested list.
# In this case it can be accessed through
# daymet_data$data. Other attributes include
# for example the tile location (daymet_data$tile),
# the altitude (daymet_data$altitude), etc.
str(daymet_data)

# load the tidyverse (install if necessary)
if(!require(tidyverse)){install.package(tidyverse)}
library(tidyverse)

# Calculate the mean temperature from min
# max temperatures and convert the year and doy
# to a proper date format.
daymet_data$data <- daymet_data$data \%>\%
 mutate(tmean = (tmax..deg.c. + tmin..deg.c.)/2,
        date = as.Date(paste(year, yday, sep = "-"), "\%Y-\%j"))

# show a simple graph of the mean temperature
plot(daymet_data$data$date,
     daymet_data$data$tmean,
     xlab = "Date",
     ylab = "mean temperature")
 
# For other practical examples consult the included
# vignette. 
}
}
\keyword{Daymet,}
\keyword{climate}
\keyword{data,}
\keyword{pixel}
\keyword{single}
