% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_daymet.r
\name{read_daymet}
\alias{read_daymet}
\title{Read Single Pixel Daymet data}
\usage{
read_daymet(file = NULL, site = NULL, skip_header = FALSE)
}
\arguments{
\item{file}{a Daymet Single Pixel data file}

\item{site}{a sitename (default = \code{NULL})}

\item{skip_header}{do not ingest header meta-data, logical \code{FALSE}
or \code{TRUE} (default = \code{FALSE})}
}
\value{
A nested data structure including site meta-data, the full
header and the data as a `data.frame()`.
}
\description{
Reads Single Pixel Daymet data into a nested list, preserving
header data and critical file name information.
}
\examples{

\dontrun{
# with defaults, outputting a data frame
# with smoothed values, overwriting the original

# download the data
download_daymet(site = "Daymet",
                 start = 1980,
                 end = 1980,
                 internal = FALSE,
                 silent = TRUE)

# read in the Daymet file
df = read_daymet(paste0(tempdir(),"/Daymet_1980_1980.csv"))

# print data structure
print(str(df))
}
}
\keyword{Daymet}
\keyword{series,}
\keyword{time}
