% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbcsp.R
\docType{methods}
\name{selectQ}
\alias{selectQ}
\alias{selectQ,dbcsp-method}
\title{Select Q best dimension}
\usage{
selectQ(
  object,
  Q = c(1, 2, 3, 5, 10, 15),
  train_size = 0.75,
  CV = FALSE,
  folds = 10,
  seed = NULL
)

\S4method{selectQ}{dbcsp}(
  object,
  Q = c(1, 2, 3, 5, 10, 15),
  train_size = 0.75,
  CV = FALSE,
  folds = 10,
  seed = NULL
)
}
\arguments{
\item{object}{object of class \code{\link[=dbcsp-class]{dbcsp}}.}

\item{Q}{list of integers which represents the dimensions to use, by default \code{Q=c(1,2,3,5,10,15)}.}

\item{train_size}{float between 0.0 and 1.0 representing the proportion of the dataset to include in the train split, by default \code{train_size=0.75}.}

\item{CV}{logical indicating if a cross validation must be performed or not (if TRUE, train_size is not used), by default \code{CV=FALSE}.}

\item{folds}{integer, number of folds to use if CV is performed.}

\item{seed}{numeric value, by default \code{seed=NULL}. Set a seed to ensure reproducible results.}
}
\value{
A \code{data.frame} including the dimensions and their corresponding accuracy values.
If \code{CV=TRUE}, for each dimension, the standard deviation of the accuracy values of the folds is also included in the data frame.
}
\description{
This function applies DB-CSP and classification with different dimensions to see which gets the best outcomes.
}
\examples{
# Read data from 2 classes
x <- AR.data$come
y <- AR.data$five
mydbcsp <- new("dbcsp", X1 = x, X2 = y)
result <- selectQ(mydbcsp)
print(result)
}
\seealso{
\code{\link[=dbcsp-class]{dbcsp}}, \code{\link[=print.dbcsp]{print}}, \code{\link[=summary.dbcsp]{summary}}, \code{\link[=train.dbcsp]{train}}, \code{\link[=predict.dbcsp]{predict}}, \code{\link[=plot.dbcsp]{plot}}, \code{\link[=boxplot.dbcsp]{boxplot}}
}
